/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.services.CreateMlModelService;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.MlFeature;
import org.openmetadata.schema.type.MlHyperParameter;
import org.openmetadata.schema.type.MlStore;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.UsageDetails;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "fullyQualifiedName", "displayName", "description", "algorithm", "mlFeatures", "mlHyperParameters", "target", "dashboard", "mlStore", "server", "href", "owner", "followers", "tags", "usageSummary", "version", "updatedAt", "updatedBy", "service", "serviceType", "changeDescription", "deleted", "extension"})
public class MlModel
implements EntityInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    private @Size(min=1, max=256) String fullyQualifiedName;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this ML Model.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="algorithm")
    @JsonPropertyDescription(value="Algorithm used to train the ML Model.")
    @NotNull
    private String algorithm;
    @JsonProperty(value="mlFeatures")
    @JsonPropertyDescription(value="Features used to train the ML Model.")
    @Valid
    private List<MlFeature> mlFeatures = null;
    @JsonProperty(value="mlHyperParameters")
    @JsonPropertyDescription(value="Hyper Parameters used to train the ML Model.")
    @Valid
    private List<MlHyperParameter> mlHyperParameters = null;
    @JsonProperty(value="target")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) String target;
    @JsonProperty(value="dashboard")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference dashboard;
    @JsonProperty(value="mlStore")
    @JsonPropertyDescription(value="Location containing the ML Model. It can be a storage layer and/or a container repository.")
    @Valid
    private MlStore mlStore;
    @JsonProperty(value="server")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI server;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="followers")
    @Valid
    private List<EntityReference> followers = null;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this ML Model.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="usageSummary")
    @JsonPropertyDescription(value="This schema defines the type for usage details. Daily, weekly, and monthly aggregation of usage is computed along with the percentile rank based on the usage for a given day.")
    @Valid
    private UsageDetails usageSummary;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double version = 0.1;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    @NotNull
    private EntityReference service;
    @JsonProperty(value="serviceType")
    @JsonPropertyDescription(value="Type of MlModel service")
    private CreateMlModelService.MlModelServiceType serviceType;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;
    @JsonProperty(value="deleted")
    @JsonPropertyDescription(value="When `true` indicates the entity has been soft deleted.")
    private Boolean deleted = false;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Entity extension data with custom attributes added to the entity.")
    private Object extension;

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public MlModel withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public MlModel withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public MlModel withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public MlModel withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public MlModel withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="algorithm")
    public String getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="algorithm")
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public MlModel withAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @JsonProperty(value="mlFeatures")
    public List<MlFeature> getMlFeatures() {
        return this.mlFeatures;
    }

    @JsonProperty(value="mlFeatures")
    public void setMlFeatures(List<MlFeature> mlFeatures) {
        this.mlFeatures = mlFeatures;
    }

    public MlModel withMlFeatures(List<MlFeature> mlFeatures) {
        this.mlFeatures = mlFeatures;
        return this;
    }

    @JsonProperty(value="mlHyperParameters")
    public List<MlHyperParameter> getMlHyperParameters() {
        return this.mlHyperParameters;
    }

    @JsonProperty(value="mlHyperParameters")
    public void setMlHyperParameters(List<MlHyperParameter> mlHyperParameters) {
        this.mlHyperParameters = mlHyperParameters;
    }

    public MlModel withMlHyperParameters(List<MlHyperParameter> mlHyperParameters) {
        this.mlHyperParameters = mlHyperParameters;
        return this;
    }

    @JsonProperty(value="target")
    public String getTarget() {
        return this.target;
    }

    @JsonProperty(value="target")
    public void setTarget(String target) {
        this.target = target;
    }

    public MlModel withTarget(String target) {
        this.target = target;
        return this;
    }

    @JsonProperty(value="dashboard")
    public EntityReference getDashboard() {
        return this.dashboard;
    }

    @JsonProperty(value="dashboard")
    public void setDashboard(EntityReference dashboard) {
        this.dashboard = dashboard;
    }

    public MlModel withDashboard(EntityReference dashboard) {
        this.dashboard = dashboard;
        return this;
    }

    @JsonProperty(value="mlStore")
    public MlStore getMlStore() {
        return this.mlStore;
    }

    @JsonProperty(value="mlStore")
    public void setMlStore(MlStore mlStore) {
        this.mlStore = mlStore;
    }

    public MlModel withMlStore(MlStore mlStore) {
        this.mlStore = mlStore;
        return this;
    }

    @JsonProperty(value="server")
    public URI getServer() {
        return this.server;
    }

    @JsonProperty(value="server")
    public void setServer(URI server) {
        this.server = server;
    }

    public MlModel withServer(URI server) {
        this.server = server;
        return this;
    }

    @Override
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public MlModel withHref(URI href) {
        this.href = href;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @Override
    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public MlModel withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @Override
    @JsonProperty(value="followers")
    public List<EntityReference> getFollowers() {
        return this.followers;
    }

    @JsonProperty(value="followers")
    public void setFollowers(List<EntityReference> followers) {
        this.followers = followers;
    }

    public MlModel withFollowers(List<EntityReference> followers) {
        this.followers = followers;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public MlModel withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="usageSummary")
    public UsageDetails getUsageSummary() {
        return this.usageSummary;
    }

    @JsonProperty(value="usageSummary")
    public void setUsageSummary(UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
    }

    public MlModel withUsageSummary(UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
        return this;
    }

    @Override
    @JsonProperty(value="version")
    public Double getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(Double version) {
        this.version = version;
    }

    public MlModel withVersion(Double version) {
        this.version = version;
        return this;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public MlModel withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public MlModel withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @JsonProperty(value="service")
    public EntityReference getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(EntityReference service) {
        this.service = service;
    }

    public MlModel withService(EntityReference service) {
        this.service = service;
        return this;
    }

    @JsonProperty(value="serviceType")
    public CreateMlModelService.MlModelServiceType getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    public void setServiceType(CreateMlModelService.MlModelServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public MlModel withServiceType(CreateMlModelService.MlModelServiceType serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public MlModel withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Override
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public MlModel withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Override
    @JsonProperty(value="extension")
    public Object getExtension() {
        return this.extension;
    }

    @Override
    @JsonProperty(value="extension")
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public MlModel withExtension(Object extension) {
        this.extension = extension;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MlModel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("algorithm");
        sb.append('=');
        sb.append(this.algorithm == null ? "<null>" : this.algorithm);
        sb.append(',');
        sb.append("mlFeatures");
        sb.append('=');
        sb.append(this.mlFeatures == null ? "<null>" : this.mlFeatures);
        sb.append(',');
        sb.append("mlHyperParameters");
        sb.append('=');
        sb.append(this.mlHyperParameters == null ? "<null>" : this.mlHyperParameters);
        sb.append(',');
        sb.append("target");
        sb.append('=');
        sb.append(this.target == null ? "<null>" : this.target);
        sb.append(',');
        sb.append("dashboard");
        sb.append('=');
        sb.append(this.dashboard == null ? "<null>" : this.dashboard);
        sb.append(',');
        sb.append("mlStore");
        sb.append('=');
        sb.append(this.mlStore == null ? "<null>" : this.mlStore);
        sb.append(',');
        sb.append("server");
        sb.append('=');
        sb.append(this.server == null ? "<null>" : this.server);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("followers");
        sb.append('=');
        sb.append(this.followers == null ? "<null>" : this.followers);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("usageSummary");
        sb.append('=');
        sb.append(this.usageSummary == null ? "<null>" : this.usageSummary);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("service");
        sb.append('=');
        sb.append(this.service == null ? "<null>" : this.service);
        sb.append(',');
        sb.append("serviceType");
        sb.append('=');
        sb.append(this.serviceType == null ? "<null>" : this.serviceType);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(this.deleted == null ? "<null>" : this.deleted);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.serviceType == null ? 0 : this.serviceType.hashCode());
        result = result * 31 + (this.server == null ? 0 : this.server.hashCode());
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.mlHyperParameters == null ? 0 : this.mlHyperParameters.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.mlFeatures == null ? 0 : this.mlFeatures.hashCode());
        result = result * 31 + (this.mlStore == null ? 0 : this.mlStore.hashCode());
        result = result * 31 + (this.usageSummary == null ? 0 : this.usageSummary.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.dashboard == null ? 0 : this.dashboard.hashCode());
        result = result * 31 + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.target == null ? 0 : this.target.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.followers == null ? 0 : this.followers.hashCode());
        result = result * 31 + (this.deleted == null ? 0 : this.deleted.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MlModel)) {
            return false;
        }
        MlModel rhs = (MlModel)other;
        return (this.serviceType == rhs.serviceType || this.serviceType != null && this.serviceType.equals(rhs.serviceType)) && (this.server == rhs.server || this.server != null && this.server.equals(rhs.server)) && (this.extension == rhs.extension || this.extension != null && this.extension.equals(rhs.extension)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.mlHyperParameters == rhs.mlHyperParameters || this.mlHyperParameters != null && this.mlHyperParameters.equals(rhs.mlHyperParameters)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.mlFeatures == rhs.mlFeatures || this.mlFeatures != null && this.mlFeatures.equals(rhs.mlFeatures)) && (this.mlStore == rhs.mlStore || this.mlStore != null && this.mlStore.equals(rhs.mlStore)) && (this.usageSummary == rhs.usageSummary || this.usageSummary != null && this.usageSummary.equals(rhs.usageSummary)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.dashboard == rhs.dashboard || this.dashboard != null && this.dashboard.equals(rhs.dashboard)) && (this.algorithm == rhs.algorithm || this.algorithm != null && this.algorithm.equals(rhs.algorithm)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt)) && (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.target == rhs.target || this.target != null && this.target.equals(rhs.target)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.followers == rhs.followers || this.followers != null && this.followers.equals(rhs.followers)) && (this.deleted == rhs.deleted || this.deleted != null && this.deleted.equals(rhs.deleted)) && (this.service == rhs.service || this.service != null && this.service.equals(rhs.service)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name));
    }
}

