/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.type.Category;
import org.openmetadata.schema.entity.type.CustomProperty;
import org.openmetadata.schema.type.ChangeDescription;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "fullyQualifiedName", "displayName", "description", "category", "nameSpace", "schema", "customProperties", "version", "updatedAt", "updatedBy", "href", "changeDescription"})
public class Type
implements EntityInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the property or entity types. Note a property name must be unique for an entity. Property name must follow camelCase naming adopted by openMetadata - must start with lower case with no space, underscore, or dots.")
    @Pattern(regexp="^(?U)[\\w]+$")
    @NotNull
    private @Pattern(regexp="^(?U)[\\w]+$") @NotNull String name;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    private @Size(min=1, max=256) String fullyQualifiedName;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this type.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    @NotNull
    private String description;
    @JsonProperty(value="category")
    @JsonPropertyDescription(value="Metadata category to which a type belongs to.")
    private Category category;
    @JsonProperty(value="nameSpace")
    @JsonPropertyDescription(value="Namespace or group to which this type belongs to. For example, some of the property types commonly used can come from `basic` namespace. Some of the entities such as `table`, `database`, etc. come from `data` namespace.")
    private String nameSpace = "custom";
    @JsonProperty(value="schema")
    @JsonPropertyDescription(value="JSON schema encoded as string. This will be used to validate the JSON fields using this schema.")
    private String schema;
    @JsonProperty(value="customProperties")
    @JsonPropertyDescription(value="Custom properties added to extend the entity. Only available for entity type")
    @Valid
    private List<CustomProperty> customProperties = new ArrayList<CustomProperty>();
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double version = 0.1;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public Type withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Type withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Type withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Type withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Type withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="category")
    public Category getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    public void setCategory(Category category) {
        this.category = category;
    }

    public Type withCategory(Category category) {
        this.category = category;
        return this;
    }

    @JsonProperty(value="nameSpace")
    public String getNameSpace() {
        return this.nameSpace;
    }

    @JsonProperty(value="nameSpace")
    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public Type withNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public Type withSchema(String schema) {
        this.schema = schema;
        return this;
    }

    @JsonProperty(value="customProperties")
    public List<CustomProperty> getCustomProperties() {
        return this.customProperties;
    }

    @JsonProperty(value="customProperties")
    public void setCustomProperties(List<CustomProperty> customProperties) {
        this.customProperties = customProperties;
    }

    public Type withCustomProperties(List<CustomProperty> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    @Override
    @JsonProperty(value="version")
    public Double getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(Double version) {
        this.version = version;
    }

    public Type withVersion(Double version) {
        this.version = version;
        return this;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Type withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Type withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Override
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public Type withHref(URI href) {
        this.href = href;
        return this;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public Type withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Type.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("category");
        sb.append('=');
        sb.append(this.category == null ? "<null>" : this.category);
        sb.append(',');
        sb.append("nameSpace");
        sb.append('=');
        sb.append(this.nameSpace == null ? "<null>" : this.nameSpace);
        sb.append(',');
        sb.append("schema");
        sb.append('=');
        sb.append(this.schema == null ? "<null>" : this.schema);
        sb.append(',');
        sb.append("customProperties");
        sb.append('=');
        sb.append(this.customProperties == null ? "<null>" : this.customProperties);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.schema == null ? 0 : this.schema.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.customProperties == null ? 0 : this.customProperties.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.nameSpace == null ? 0 : this.nameSpace.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.category == null ? 0 : this.category.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Type)) {
            return false;
        }
        Type rhs = (Type)other;
        return (this.schema == rhs.schema || this.schema != null && this.schema.equals(rhs.schema)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.customProperties == rhs.customProperties || this.customProperties != null && this.customProperties.equals(rhs.customProperties)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.nameSpace == rhs.nameSpace || this.nameSpace != null && this.nameSpace.equals(rhs.nameSpace)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.category == rhs.category || this.category != null && this.category.equals((Object)rhs.category)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt));
    }
}

