/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.email;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"emailingEntity", "supportUrl", "enableSmtpServer", "openMetadataUrl", "senderMail", "serverEndpoint", "serverPort", "username", "password", "transportationStrategy"})
public class SmtpSettings {
    @JsonProperty(value="emailingEntity")
    @JsonPropertyDescription(value="Emailing Entity")
    private String emailingEntity = "OpenMetadata";
    @JsonProperty(value="supportUrl")
    @JsonPropertyDescription(value="Support Url")
    private String supportUrl = "https://slack.open-metadata.org";
    @JsonProperty(value="enableSmtpServer")
    @JsonPropertyDescription(value="If this is enable password will details will be shared on mail")
    private Boolean enableSmtpServer = false;
    @JsonProperty(value="openMetadataUrl")
    @JsonPropertyDescription(value="Openmetadata Server Endpoint")
    @NotNull
    private String openMetadataUrl;
    @JsonProperty(value="senderMail")
    @JsonPropertyDescription(value="Mail of the sender")
    @NotNull
    private String senderMail;
    @JsonProperty(value="serverEndpoint")
    @JsonPropertyDescription(value="Smtp Server Endpoint")
    @NotNull
    private String serverEndpoint;
    @JsonProperty(value="serverPort")
    @JsonPropertyDescription(value="Smtp Server Endpoint")
    @NotNull
    private Integer serverPort;
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Smtp Server Username")
    @NotNull
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Smtp Server Password")
    @NotNull
    private String password;
    @JsonProperty(value="transportationStrategy")
    private TransportationStrategy transportationStrategy = TransportationStrategy.fromValue("SMTP");

    @JsonProperty(value="emailingEntity")
    public String getEmailingEntity() {
        return this.emailingEntity;
    }

    @JsonProperty(value="emailingEntity")
    public void setEmailingEntity(String emailingEntity) {
        this.emailingEntity = emailingEntity;
    }

    public SmtpSettings withEmailingEntity(String emailingEntity) {
        this.emailingEntity = emailingEntity;
        return this;
    }

    @JsonProperty(value="supportUrl")
    public String getSupportUrl() {
        return this.supportUrl;
    }

    @JsonProperty(value="supportUrl")
    public void setSupportUrl(String supportUrl) {
        this.supportUrl = supportUrl;
    }

    public SmtpSettings withSupportUrl(String supportUrl) {
        this.supportUrl = supportUrl;
        return this;
    }

    @JsonProperty(value="enableSmtpServer")
    public Boolean getEnableSmtpServer() {
        return this.enableSmtpServer;
    }

    @JsonProperty(value="enableSmtpServer")
    public void setEnableSmtpServer(Boolean enableSmtpServer) {
        this.enableSmtpServer = enableSmtpServer;
    }

    public SmtpSettings withEnableSmtpServer(Boolean enableSmtpServer) {
        this.enableSmtpServer = enableSmtpServer;
        return this;
    }

    @JsonProperty(value="openMetadataUrl")
    public String getOpenMetadataUrl() {
        return this.openMetadataUrl;
    }

    @JsonProperty(value="openMetadataUrl")
    public void setOpenMetadataUrl(String openMetadataUrl) {
        this.openMetadataUrl = openMetadataUrl;
    }

    public SmtpSettings withOpenMetadataUrl(String openMetadataUrl) {
        this.openMetadataUrl = openMetadataUrl;
        return this;
    }

    @JsonProperty(value="senderMail")
    public String getSenderMail() {
        return this.senderMail;
    }

    @JsonProperty(value="senderMail")
    public void setSenderMail(String senderMail) {
        this.senderMail = senderMail;
    }

    public SmtpSettings withSenderMail(String senderMail) {
        this.senderMail = senderMail;
        return this;
    }

    @JsonProperty(value="serverEndpoint")
    public String getServerEndpoint() {
        return this.serverEndpoint;
    }

    @JsonProperty(value="serverEndpoint")
    public void setServerEndpoint(String serverEndpoint) {
        this.serverEndpoint = serverEndpoint;
    }

    public SmtpSettings withServerEndpoint(String serverEndpoint) {
        this.serverEndpoint = serverEndpoint;
        return this;
    }

    @JsonProperty(value="serverPort")
    public Integer getServerPort() {
        return this.serverPort;
    }

    @JsonProperty(value="serverPort")
    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public SmtpSettings withServerPort(Integer serverPort) {
        this.serverPort = serverPort;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public SmtpSettings withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public SmtpSettings withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="transportationStrategy")
    public TransportationStrategy getTransportationStrategy() {
        return this.transportationStrategy;
    }

    @JsonProperty(value="transportationStrategy")
    public void setTransportationStrategy(TransportationStrategy transportationStrategy) {
        this.transportationStrategy = transportationStrategy;
    }

    public SmtpSettings withTransportationStrategy(TransportationStrategy transportationStrategy) {
        this.transportationStrategy = transportationStrategy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SmtpSettings.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("emailingEntity");
        sb.append('=');
        sb.append(this.emailingEntity == null ? "<null>" : this.emailingEntity);
        sb.append(',');
        sb.append("supportUrl");
        sb.append('=');
        sb.append(this.supportUrl == null ? "<null>" : this.supportUrl);
        sb.append(',');
        sb.append("enableSmtpServer");
        sb.append('=');
        sb.append(this.enableSmtpServer == null ? "<null>" : this.enableSmtpServer);
        sb.append(',');
        sb.append("openMetadataUrl");
        sb.append('=');
        sb.append(this.openMetadataUrl == null ? "<null>" : this.openMetadataUrl);
        sb.append(',');
        sb.append("senderMail");
        sb.append('=');
        sb.append(this.senderMail == null ? "<null>" : this.senderMail);
        sb.append(',');
        sb.append("serverEndpoint");
        sb.append('=');
        sb.append(this.serverEndpoint == null ? "<null>" : this.serverEndpoint);
        sb.append(',');
        sb.append("serverPort");
        sb.append('=');
        sb.append(this.serverPort == null ? "<null>" : this.serverPort);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("transportationStrategy");
        sb.append('=');
        sb.append(this.transportationStrategy == null ? "<null>" : this.transportationStrategy);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.enableSmtpServer == null ? 0 : this.enableSmtpServer.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.emailingEntity == null ? 0 : this.emailingEntity.hashCode());
        result = result * 31 + (this.serverEndpoint == null ? 0 : this.serverEndpoint.hashCode());
        result = result * 31 + (this.supportUrl == null ? 0 : this.supportUrl.hashCode());
        result = result * 31 + (this.openMetadataUrl == null ? 0 : this.openMetadataUrl.hashCode());
        result = result * 31 + (this.transportationStrategy == null ? 0 : this.transportationStrategy.hashCode());
        result = result * 31 + (this.serverPort == null ? 0 : this.serverPort.hashCode());
        result = result * 31 + (this.senderMail == null ? 0 : this.senderMail.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SmtpSettings)) {
            return false;
        }
        SmtpSettings rhs = (SmtpSettings)other;
        return (this.enableSmtpServer == rhs.enableSmtpServer || this.enableSmtpServer != null && this.enableSmtpServer.equals(rhs.enableSmtpServer)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.emailingEntity == rhs.emailingEntity || this.emailingEntity != null && this.emailingEntity.equals(rhs.emailingEntity)) && (this.serverEndpoint == rhs.serverEndpoint || this.serverEndpoint != null && this.serverEndpoint.equals(rhs.serverEndpoint)) && (this.supportUrl == rhs.supportUrl || this.supportUrl != null && this.supportUrl.equals(rhs.supportUrl)) && (this.openMetadataUrl == rhs.openMetadataUrl || this.openMetadataUrl != null && this.openMetadataUrl.equals(rhs.openMetadataUrl)) && (this.transportationStrategy == rhs.transportationStrategy || this.transportationStrategy != null && this.transportationStrategy.equals((Object)rhs.transportationStrategy)) && (this.serverPort == rhs.serverPort || this.serverPort != null && this.serverPort.equals(rhs.serverPort)) && (this.senderMail == rhs.senderMail || this.senderMail != null && this.senderMail.equals(rhs.senderMail)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum TransportationStrategy {
        SMTP("SMTP"),
        SMPTS("SMPTS"),
        SMTP_TLS("SMTP_TLS");

        private final String value;
        private static final Map<String, TransportationStrategy> CONSTANTS;

        private TransportationStrategy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TransportationStrategy fromValue(String value) {
            TransportationStrategy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TransportationStrategy>();
            for (TransportationStrategy c : TransportationStrategy.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

