/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.email;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "email"})
public class NameEmailPair {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name")
    private String name;
    @JsonProperty(value="email")
    @JsonPropertyDescription(value="Email address of a user or other entities.")
    @Pattern(regexp="^\\S+@\\S+\\.\\S+$")
    @Size(min=6, max=127)
    @NotNull
    private @Pattern(regexp="^\\S+@\\S+\\.\\S+$") @Size(min=6, max=127) @NotNull String email;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public NameEmailPair withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    public NameEmailPair withEmail(String email) {
        this.email = email;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(NameEmailPair.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(this.email == null ? "<null>" : this.email);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof NameEmailPair)) {
            return false;
        }
        NameEmailPair rhs = (NameEmailPair)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.email == rhs.email || this.email != null && this.email.equals(rhs.email));
    }
}

