/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.dataInsight.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.openmetadata.schema.dataInsight.type.KpiTarget;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"timestamp", "kpiFqn", "targetResult"})
public class KpiResult {
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    @NotNull
    private Long timestamp;
    @JsonProperty(value="kpiFqn")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    private @Size(min=1, max=256) String kpiFqn;
    @JsonProperty(value="targetResult")
    @JsonPropertyDescription(value="Metric and their corresponding current results")
    @Valid
    @NotNull
    private List<KpiTarget> targetResult = new ArrayList<KpiTarget>();

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public KpiResult withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="kpiFqn")
    public String getKpiFqn() {
        return this.kpiFqn;
    }

    @JsonProperty(value="kpiFqn")
    public void setKpiFqn(String kpiFqn) {
        this.kpiFqn = kpiFqn;
    }

    public KpiResult withKpiFqn(String kpiFqn) {
        this.kpiFqn = kpiFqn;
        return this;
    }

    @JsonProperty(value="targetResult")
    public List<KpiTarget> getTargetResult() {
        return this.targetResult;
    }

    @JsonProperty(value="targetResult")
    public void setTargetResult(List<KpiTarget> targetResult) {
        this.targetResult = targetResult;
    }

    public KpiResult withTargetResult(List<KpiTarget> targetResult) {
        this.targetResult = targetResult;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(KpiResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("kpiFqn");
        sb.append('=');
        sb.append(this.kpiFqn == null ? "<null>" : this.kpiFqn);
        sb.append(',');
        sb.append("targetResult");
        sb.append('=');
        sb.append(this.targetResult == null ? "<null>" : this.targetResult);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.targetResult == null ? 0 : this.targetResult.hashCode());
        result = result * 31 + (this.kpiFqn == null ? 0 : this.kpiFqn.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof KpiResult)) {
            return false;
        }
        KpiResult rhs = (KpiResult)other;
        return (this.targetResult == rhs.targetResult || this.targetResult != null && this.targetResult.equals(rhs.targetResult)) && (this.kpiFqn == rhs.kpiFqn || this.kpiFqn != null && this.kpiFqn.equals(rhs.kpiFqn)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

