/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ServiceTokenType {
    BOT("BOT"),
    OM_USER("OM_USER"),
    PERSONAL_ACCESS("PERSONAL_ACCESS");

    private final String value;
    private static final Map<String, ServiceTokenType> CONSTANTS;

    private ServiceTokenType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ServiceTokenType fromValue(String value) {
        ServiceTokenType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ServiceTokenType>();
        for (ServiceTokenType c : ServiceTokenType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

