/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"ssoServiceType", "authConfig"})
public class SSOAuthMechanism {
    @JsonProperty(value="ssoServiceType")
    @JsonPropertyDescription(value="Type of database service such as Amundsen, Atlas...")
    private SsoServiceType ssoServiceType;
    @JsonProperty(value="authConfig")
    @JsonPropertyDescription(value="The authentication configuration used by the SSO")
    private Object authConfig;

    @JsonProperty(value="ssoServiceType")
    public SsoServiceType getSsoServiceType() {
        return this.ssoServiceType;
    }

    @JsonProperty(value="ssoServiceType")
    public void setSsoServiceType(SsoServiceType ssoServiceType) {
        this.ssoServiceType = ssoServiceType;
    }

    public SSOAuthMechanism withSsoServiceType(SsoServiceType ssoServiceType) {
        this.ssoServiceType = ssoServiceType;
        return this;
    }

    @JsonProperty(value="authConfig")
    public Object getAuthConfig() {
        return this.authConfig;
    }

    @JsonProperty(value="authConfig")
    public void setAuthConfig(Object authConfig) {
        this.authConfig = authConfig;
    }

    public SSOAuthMechanism withAuthConfig(Object authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SSOAuthMechanism.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("ssoServiceType");
        sb.append('=');
        sb.append(this.ssoServiceType == null ? "<null>" : this.ssoServiceType);
        sb.append(',');
        sb.append("authConfig");
        sb.append('=');
        sb.append(this.authConfig == null ? "<null>" : this.authConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.ssoServiceType == null ? 0 : this.ssoServiceType.hashCode());
        result = result * 31 + (this.authConfig == null ? 0 : this.authConfig.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SSOAuthMechanism)) {
            return false;
        }
        SSOAuthMechanism rhs = (SSOAuthMechanism)other;
        return (this.ssoServiceType == rhs.ssoServiceType || this.ssoServiceType != null && this.ssoServiceType.equals((Object)rhs.ssoServiceType)) && (this.authConfig == rhs.authConfig || this.authConfig != null && this.authConfig.equals(rhs.authConfig));
    }

    public static enum SsoServiceType {
        GOOGLE("google"),
        OKTA("okta"),
        AUTH_0("auth0"),
        CUSTOM_OIDC("custom-oidc"),
        AZURE("azure"),
        BASIC("basic"),
        SAML("saml");

        private final String value;
        private static final Map<String, SsoServiceType> CONSTANTS;

        private SsoServiceType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SsoServiceType fromValue(String value) {
            SsoServiceType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SsoServiceType>();
            for (SsoServiceType c : SsoServiceType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

