/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.auth;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"firstName", "lastName", "email", "password"})
public class RegistrationRequest {
    @JsonProperty(value="firstName")
    @JsonPropertyDescription(value="First Name")
    @NotNull
    private String firstName;
    @JsonProperty(value="lastName")
    @JsonPropertyDescription(value="Last Name")
    @NotNull
    private String lastName;
    @JsonProperty(value="email")
    @JsonPropertyDescription(value="Email address of a user or other entities.")
    @Pattern(regexp="^\\S+@\\S+\\.\\S+$")
    @Size(min=6, max=127)
    @NotNull
    private @Pattern(regexp="^\\S+@\\S+\\.\\S+$") @Size(min=6, max=127) @NotNull String email;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Login Password")
    @Size(min=8, max=16)
    @NotNull
    private @Size(min=8, max=16) @NotNull String password;

    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public RegistrationRequest withFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public RegistrationRequest withLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    public RegistrationRequest withEmail(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public RegistrationRequest withPassword(String password) {
        this.password = password;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RegistrationRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("firstName");
        sb.append('=');
        sb.append(this.firstName == null ? "<null>" : this.firstName);
        sb.append(',');
        sb.append("lastName");
        sb.append('=');
        sb.append(this.lastName == null ? "<null>" : this.lastName);
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(this.email == null ? "<null>" : this.email);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.firstName == null ? 0 : this.firstName.hashCode());
        result = result * 31 + (this.lastName == null ? 0 : this.lastName.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RegistrationRequest)) {
            return false;
        }
        RegistrationRequest rhs = (RegistrationRequest)other;
        return (this.firstName == rhs.firstName || this.firstName != null && this.firstName.equals(rhs.firstName)) && (this.lastName == rhs.lastName || this.lastName != null && this.lastName.equals(rhs.lastName)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.email == rhs.email || this.email != null && this.email.equals(rhs.email));
    }
}

