/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.auth;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.schema.auth.TokenType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"token", "tokenName", "userId", "tokenType", "expiryDate", "jwtToken"})
public class PersonalAccessToken
implements TokenInterface {
    @JsonProperty(value="token")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID token;
    @JsonProperty(value="tokenName")
    @JsonPropertyDescription(value="Name of the token")
    private String tokenName;
    @JsonProperty(value="userId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID userId;
    @JsonProperty(value="tokenType")
    @JsonPropertyDescription(value="Different Type of User token")
    private TokenType tokenType;
    @JsonProperty(value="expiryDate")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    @NotNull
    private Long expiryDate;
    @JsonProperty(value="jwtToken")
    @JsonPropertyDescription(value="JWT Auth Token.")
    private String jwtToken;

    @Override
    @JsonProperty(value="token")
    public UUID getToken() {
        return this.token;
    }

    @Override
    @JsonProperty(value="token")
    public void setToken(UUID token) {
        this.token = token;
    }

    public PersonalAccessToken withToken(UUID token) {
        this.token = token;
        return this;
    }

    @JsonProperty(value="tokenName")
    public String getTokenName() {
        return this.tokenName;
    }

    @JsonProperty(value="tokenName")
    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public PersonalAccessToken withTokenName(String tokenName) {
        this.tokenName = tokenName;
        return this;
    }

    @Override
    @JsonProperty(value="userId")
    public UUID getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="userId")
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public PersonalAccessToken withUserId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @Override
    @JsonProperty(value="tokenType")
    public TokenType getTokenType() {
        return this.tokenType;
    }

    @Override
    @JsonProperty(value="tokenType")
    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public PersonalAccessToken withTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Override
    @JsonProperty(value="expiryDate")
    public Long getExpiryDate() {
        return this.expiryDate;
    }

    @Override
    @JsonProperty(value="expiryDate")
    public void setExpiryDate(Long expiryDate) {
        this.expiryDate = expiryDate;
    }

    public PersonalAccessToken withExpiryDate(Long expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @JsonProperty(value="jwtToken")
    public String getJwtToken() {
        return this.jwtToken;
    }

    @JsonProperty(value="jwtToken")
    public void setJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    public PersonalAccessToken withJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PersonalAccessToken.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("token");
        sb.append('=');
        sb.append(this.token == null ? "<null>" : this.token);
        sb.append(',');
        sb.append("tokenName");
        sb.append('=');
        sb.append(this.tokenName == null ? "<null>" : this.tokenName);
        sb.append(',');
        sb.append("userId");
        sb.append('=');
        sb.append(this.userId == null ? "<null>" : this.userId);
        sb.append(',');
        sb.append("tokenType");
        sb.append('=');
        sb.append(this.tokenType == null ? "<null>" : this.tokenType);
        sb.append(',');
        sb.append("expiryDate");
        sb.append('=');
        sb.append(this.expiryDate == null ? "<null>" : this.expiryDate);
        sb.append(',');
        sb.append("jwtToken");
        sb.append('=');
        sb.append(this.jwtToken == null ? "<null>" : this.jwtToken);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.expiryDate == null ? 0 : this.expiryDate.hashCode());
        result = result * 31 + (this.tokenName == null ? 0 : this.tokenName.hashCode());
        result = result * 31 + (this.jwtToken == null ? 0 : this.jwtToken.hashCode());
        result = result * 31 + (this.tokenType == null ? 0 : this.tokenType.hashCode());
        result = result * 31 + (this.userId == null ? 0 : this.userId.hashCode());
        result = result * 31 + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PersonalAccessToken)) {
            return false;
        }
        PersonalAccessToken rhs = (PersonalAccessToken)other;
        return (this.expiryDate == rhs.expiryDate || this.expiryDate != null && this.expiryDate.equals(rhs.expiryDate)) && (this.tokenName == rhs.tokenName || this.tokenName != null && this.tokenName.equals(rhs.tokenName)) && (this.jwtToken == rhs.jwtToken || this.jwtToken != null && this.jwtToken.equals(rhs.jwtToken)) && (this.tokenType == rhs.tokenType || this.tokenType != null && this.tokenType.equals((Object)rhs.tokenType)) && (this.userId == rhs.userId || this.userId != null && this.userId.equals(rhs.userId)) && (this.token == rhs.token || this.token != null && this.token.equals(rhs.token));
    }
}

