/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.auth;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.auth.JWTTokenExpiry;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"JWTToken", "JWTTokenExpiry", "JWTTokenExpiresAt"})
public class JWTAuthMechanism {
    @JsonProperty(value="JWTToken")
    @JsonPropertyDescription(value="JWT Auth Token.")
    @NotNull
    private String jWTToken;
    @JsonProperty(value="JWTTokenExpiry")
    @JsonPropertyDescription(value="JWT Auth Token expiration in days")
    @NotNull
    private JWTTokenExpiry jWTTokenExpiry;
    @JsonProperty(value="JWTTokenExpiresAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long jWTTokenExpiresAt;

    @JsonProperty(value="JWTToken")
    public String getJWTToken() {
        return this.jWTToken;
    }

    @JsonProperty(value="JWTToken")
    public void setJWTToken(String jWTToken) {
        this.jWTToken = jWTToken;
    }

    public JWTAuthMechanism withJWTToken(String jWTToken) {
        this.jWTToken = jWTToken;
        return this;
    }

    @JsonProperty(value="JWTTokenExpiry")
    public JWTTokenExpiry getJWTTokenExpiry() {
        return this.jWTTokenExpiry;
    }

    @JsonProperty(value="JWTTokenExpiry")
    public void setJWTTokenExpiry(JWTTokenExpiry jWTTokenExpiry) {
        this.jWTTokenExpiry = jWTTokenExpiry;
    }

    public JWTAuthMechanism withJWTTokenExpiry(JWTTokenExpiry jWTTokenExpiry) {
        this.jWTTokenExpiry = jWTTokenExpiry;
        return this;
    }

    @JsonProperty(value="JWTTokenExpiresAt")
    public Long getJWTTokenExpiresAt() {
        return this.jWTTokenExpiresAt;
    }

    @JsonProperty(value="JWTTokenExpiresAt")
    public void setJWTTokenExpiresAt(Long jWTTokenExpiresAt) {
        this.jWTTokenExpiresAt = jWTTokenExpiresAt;
    }

    public JWTAuthMechanism withJWTTokenExpiresAt(Long jWTTokenExpiresAt) {
        this.jWTTokenExpiresAt = jWTTokenExpiresAt;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JWTAuthMechanism.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("jWTToken");
        sb.append('=');
        sb.append(this.jWTToken == null ? "<null>" : this.jWTToken);
        sb.append(',');
        sb.append("jWTTokenExpiry");
        sb.append('=');
        sb.append(this.jWTTokenExpiry == null ? "<null>" : this.jWTTokenExpiry);
        sb.append(',');
        sb.append("jWTTokenExpiresAt");
        sb.append('=');
        sb.append(this.jWTTokenExpiresAt == null ? "<null>" : this.jWTTokenExpiresAt);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.jWTTokenExpiry == null ? 0 : this.jWTTokenExpiry.hashCode());
        result = result * 31 + (this.jWTToken == null ? 0 : this.jWTToken.hashCode());
        result = result * 31 + (this.jWTTokenExpiresAt == null ? 0 : this.jWTTokenExpiresAt.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof JWTAuthMechanism)) {
            return false;
        }
        JWTAuthMechanism rhs = (JWTAuthMechanism)other;
        return (this.jWTTokenExpiry == rhs.jWTTokenExpiry || this.jWTTokenExpiry != null && this.jWTTokenExpiry.equals((Object)rhs.jWTTokenExpiry)) && (this.jWTToken == rhs.jWTToken || this.jWTToken != null && this.jWTToken.equals(rhs.jWTToken)) && (this.jWTTokenExpiresAt == rhs.jWTTokenExpiresAt || this.jWTTokenExpiresAt != null && this.jWTTokenExpiresAt.equals(rhs.jWTTokenExpiresAt));
    }
}

