/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.tests;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.analytics.type.WebAnalyticEventType;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "eventType", "owner"})
public class CreateWebAnalyticEvent
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name the report definition.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="eventType")
    @JsonPropertyDescription(value="event type")
    @NotNull
    private WebAnalyticEventType eventType;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateWebAnalyticEvent withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateWebAnalyticEvent withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateWebAnalyticEvent withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="eventType")
    public WebAnalyticEventType getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="eventType")
    public void setEventType(WebAnalyticEventType eventType) {
        this.eventType = eventType;
    }

    public CreateWebAnalyticEvent withEventType(WebAnalyticEventType eventType) {
        this.eventType = eventType;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateWebAnalyticEvent withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateWebAnalyticEvent.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("eventType");
        sb.append('=');
        sb.append(this.eventType == null ? "<null>" : this.eventType);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateWebAnalyticEvent)) {
            return false;
        }
        CreateWebAnalyticEvent rhs = (CreateWebAnalyticEvent)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.eventType == rhs.eventType || this.eventType != null && this.eventType.equals((Object)rhs.eventType)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName));
    }
}

