/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.tests;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.tests.TestCaseParameter;
import org.openmetadata.schema.tests.TestPlatform;
import org.openmetadata.schema.type.ColumnDataType;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TestDefinitionEntityType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "owner", "entityType", "testPlatforms", "supportedDataTypes", "parameterDefinition"})
public class CreateTestDefinition
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this test case.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    @NotNull
    private String description;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="entityType")
    @JsonPropertyDescription(value="This enum defines the type for which this test definition applies to.")
    @NotNull
    private TestDefinitionEntityType entityType;
    @JsonProperty(value="testPlatforms")
    @Valid
    @NotNull
    private List<TestPlatform> testPlatforms = new ArrayList<TestPlatform>();
    @JsonProperty(value="supportedDataTypes")
    @Valid
    private List<ColumnDataType> supportedDataTypes = new ArrayList<ColumnDataType>();
    @JsonProperty(value="parameterDefinition")
    @Valid
    private List<TestCaseParameter> parameterDefinition = new ArrayList<TestCaseParameter>();

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateTestDefinition withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateTestDefinition withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateTestDefinition withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateTestDefinition withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="entityType")
    public TestDefinitionEntityType getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    public void setEntityType(TestDefinitionEntityType entityType) {
        this.entityType = entityType;
    }

    public CreateTestDefinition withEntityType(TestDefinitionEntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    @JsonProperty(value="testPlatforms")
    public List<TestPlatform> getTestPlatforms() {
        return this.testPlatforms;
    }

    @JsonProperty(value="testPlatforms")
    public void setTestPlatforms(List<TestPlatform> testPlatforms) {
        this.testPlatforms = testPlatforms;
    }

    public CreateTestDefinition withTestPlatforms(List<TestPlatform> testPlatforms) {
        this.testPlatforms = testPlatforms;
        return this;
    }

    @JsonProperty(value="supportedDataTypes")
    public List<ColumnDataType> getSupportedDataTypes() {
        return this.supportedDataTypes;
    }

    @JsonProperty(value="supportedDataTypes")
    public void setSupportedDataTypes(List<ColumnDataType> supportedDataTypes) {
        this.supportedDataTypes = supportedDataTypes;
    }

    public CreateTestDefinition withSupportedDataTypes(List<ColumnDataType> supportedDataTypes) {
        this.supportedDataTypes = supportedDataTypes;
        return this;
    }

    @JsonProperty(value="parameterDefinition")
    public List<TestCaseParameter> getParameterDefinition() {
        return this.parameterDefinition;
    }

    @JsonProperty(value="parameterDefinition")
    public void setParameterDefinition(List<TestCaseParameter> parameterDefinition) {
        this.parameterDefinition = parameterDefinition;
    }

    public CreateTestDefinition withParameterDefinition(List<TestCaseParameter> parameterDefinition) {
        this.parameterDefinition = parameterDefinition;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateTestDefinition.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("entityType");
        sb.append('=');
        sb.append(this.entityType == null ? "<null>" : this.entityType);
        sb.append(',');
        sb.append("testPlatforms");
        sb.append('=');
        sb.append(this.testPlatforms == null ? "<null>" : this.testPlatforms);
        sb.append(',');
        sb.append("supportedDataTypes");
        sb.append('=');
        sb.append(this.supportedDataTypes == null ? "<null>" : this.supportedDataTypes);
        sb.append(',');
        sb.append("parameterDefinition");
        sb.append('=');
        sb.append(this.parameterDefinition == null ? "<null>" : this.parameterDefinition);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.testPlatforms == null ? 0 : this.testPlatforms.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.supportedDataTypes == null ? 0 : this.supportedDataTypes.hashCode());
        result = result * 31 + (this.parameterDefinition == null ? 0 : this.parameterDefinition.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateTestDefinition)) {
            return false;
        }
        CreateTestDefinition rhs = (CreateTestDefinition)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.testPlatforms == rhs.testPlatforms || this.testPlatforms != null && this.testPlatforms.equals(rhs.testPlatforms)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.entityType == rhs.entityType || this.entityType != null && this.entityType.equals((Object)rhs.entityType)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.supportedDataTypes == rhs.supportedDataTypes || this.supportedDataTypes != null && this.supportedDataTypes.equals(rhs.supportedDataTypes)) && (this.parameterDefinition == rhs.parameterDefinition || this.parameterDefinition != null && this.parameterDefinition.equals(rhs.parameterDefinition));
    }
}

