/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.tests;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.tests.TestCaseParameterValue;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "description", "displayName", "testDefinition", "entityLink", "testSuite", "parameterValues", "owner"})
public class CreateTestCase
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this test.")
    private String displayName;
    @JsonProperty(value="testDefinition")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    @NotNull
    private @Size(min=1, max=256) @NotNull String testDefinition;
    @JsonProperty(value="entityLink")
    @JsonPropertyDescription(value="Link to an entity or field within an entity using this format `<#E::{entities}::{entityType}::{field}::{arrayFieldName}::{arrayFieldValue}`.")
    @Pattern(regexp="^(?U)<#E::\\w+::[\\w'\\- .&/:+\"\\\\()$#]+>$")
    @NotNull
    private @Pattern(regexp="^(?U)<#E::\\w+::[\\w'\\- .&/:+\"\\\\()$#]+>$") @NotNull String entityLink;
    @JsonProperty(value="testSuite")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    @NotNull
    private @Size(min=1, max=256) @NotNull String testSuite;
    @JsonProperty(value="parameterValues")
    @Valid
    private List<TestCaseParameterValue> parameterValues = new ArrayList<TestCaseParameterValue>();
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateTestCase withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateTestCase withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateTestCase withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty(value="testDefinition")
    public String getTestDefinition() {
        return this.testDefinition;
    }

    @JsonProperty(value="testDefinition")
    public void setTestDefinition(String testDefinition) {
        this.testDefinition = testDefinition;
    }

    public CreateTestCase withTestDefinition(String testDefinition) {
        this.testDefinition = testDefinition;
        return this;
    }

    @JsonProperty(value="entityLink")
    public String getEntityLink() {
        return this.entityLink;
    }

    @JsonProperty(value="entityLink")
    public void setEntityLink(String entityLink) {
        this.entityLink = entityLink;
    }

    public CreateTestCase withEntityLink(String entityLink) {
        this.entityLink = entityLink;
        return this;
    }

    @JsonProperty(value="testSuite")
    public String getTestSuite() {
        return this.testSuite;
    }

    @JsonProperty(value="testSuite")
    public void setTestSuite(String testSuite) {
        this.testSuite = testSuite;
    }

    public CreateTestCase withTestSuite(String testSuite) {
        this.testSuite = testSuite;
        return this;
    }

    @JsonProperty(value="parameterValues")
    public List<TestCaseParameterValue> getParameterValues() {
        return this.parameterValues;
    }

    @JsonProperty(value="parameterValues")
    public void setParameterValues(List<TestCaseParameterValue> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public CreateTestCase withParameterValues(List<TestCaseParameterValue> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateTestCase withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateTestCase.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("testDefinition");
        sb.append('=');
        sb.append(this.testDefinition == null ? "<null>" : this.testDefinition);
        sb.append(',');
        sb.append("entityLink");
        sb.append('=');
        sb.append(this.entityLink == null ? "<null>" : this.entityLink);
        sb.append(',');
        sb.append("testSuite");
        sb.append('=');
        sb.append(this.testSuite == null ? "<null>" : this.testSuite);
        sb.append(',');
        sb.append("parameterValues");
        sb.append('=');
        sb.append(this.parameterValues == null ? "<null>" : this.parameterValues);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.testSuite == null ? 0 : this.testSuite.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.entityLink == null ? 0 : this.entityLink.hashCode());
        result = result * 31 + (this.testDefinition == null ? 0 : this.testDefinition.hashCode());
        result = result * 31 + (this.parameterValues == null ? 0 : this.parameterValues.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateTestCase)) {
            return false;
        }
        CreateTestCase rhs = (CreateTestCase)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.testSuite == rhs.testSuite || this.testSuite != null && this.testSuite.equals(rhs.testSuite)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.entityLink == rhs.entityLink || this.entityLink != null && this.entityLink.equals(rhs.entityLink)) && (this.testDefinition == rhs.testDefinition || this.testDefinition != null && this.testDefinition.equals(rhs.testDefinition)) && (this.parameterValues == rhs.parameterValues || this.parameterValues != null && this.parameterValues.equals(rhs.parameterValues));
    }
}

