/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.lineage;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.EntitiesEdge;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"description", "edge"})
public class AddLineage {
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="edge")
    @JsonPropertyDescription(value="Edge in the lineage graph from one entity to another using entity references.")
    @Valid
    @NotNull
    private EntitiesEdge edge;

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public AddLineage withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="edge")
    public EntitiesEdge getEdge() {
        return this.edge;
    }

    @JsonProperty(value="edge")
    public void setEdge(EntitiesEdge edge) {
        this.edge = edge;
    }

    public AddLineage withEdge(EntitiesEdge edge) {
        this.edge = edge;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AddLineage.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("edge");
        sb.append('=');
        sb.append(this.edge == null ? "<null>" : this.edge);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.edge == null ? 0 : this.edge.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AddLineage)) {
            return false;
        }
        AddLineage rhs = (AddLineage)other;
        return (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.edge == rhs.edge || this.edge != null && this.edge.equals(rhs.edge));
    }
}

