/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.dataInsight;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.dataInsight.ChartParameterValues;
import org.openmetadata.schema.type.DataReportIndex;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "dataIndexType", "dimensions", "metrics", "owner"})
public class CreateDataInsightChart
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name the data insight chart.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="dataIndexType")
    @JsonPropertyDescription(value="Index where data are stored")
    private DataReportIndex dataIndexType;
    @JsonProperty(value="dimensions")
    @JsonPropertyDescription(value="Dimensions of the chart")
    @Valid
    private List<ChartParameterValues> dimensions = new ArrayList<ChartParameterValues>();
    @JsonProperty(value="metrics")
    @JsonPropertyDescription(value="Metrics of the chart")
    @Valid
    private List<ChartParameterValues> metrics = new ArrayList<ChartParameterValues>();
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateDataInsightChart withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateDataInsightChart withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateDataInsightChart withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="dataIndexType")
    public DataReportIndex getDataIndexType() {
        return this.dataIndexType;
    }

    @JsonProperty(value="dataIndexType")
    public void setDataIndexType(DataReportIndex dataIndexType) {
        this.dataIndexType = dataIndexType;
    }

    public CreateDataInsightChart withDataIndexType(DataReportIndex dataIndexType) {
        this.dataIndexType = dataIndexType;
        return this;
    }

    @JsonProperty(value="dimensions")
    public List<ChartParameterValues> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty(value="dimensions")
    public void setDimensions(List<ChartParameterValues> dimensions) {
        this.dimensions = dimensions;
    }

    public CreateDataInsightChart withDimensions(List<ChartParameterValues> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @JsonProperty(value="metrics")
    public List<ChartParameterValues> getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    public void setMetrics(List<ChartParameterValues> metrics) {
        this.metrics = metrics;
    }

    public CreateDataInsightChart withMetrics(List<ChartParameterValues> metrics) {
        this.metrics = metrics;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateDataInsightChart withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateDataInsightChart.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("dataIndexType");
        sb.append('=');
        sb.append(this.dataIndexType == null ? "<null>" : this.dataIndexType);
        sb.append(',');
        sb.append("dimensions");
        sb.append('=');
        sb.append(this.dimensions == null ? "<null>" : this.dimensions);
        sb.append(',');
        sb.append("metrics");
        sb.append('=');
        sb.append(this.metrics == null ? "<null>" : this.metrics);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.dataIndexType == null ? 0 : this.dataIndexType.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.metrics == null ? 0 : this.metrics.hashCode());
        result = result * 31 + (this.dimensions == null ? 0 : this.dimensions.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateDataInsightChart)) {
            return false;
        }
        CreateDataInsightChart rhs = (CreateDataInsightChart)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.dataIndexType == rhs.dataIndexType || this.dataIndexType != null && this.dataIndexType.equals((Object)rhs.dataIndexType)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.metrics == rhs.metrics || this.metrics != null && this.metrics.equals(rhs.metrics)) && (this.dimensions == rhs.dimensions || this.dimensions != null && this.dimensions.equals(rhs.dimensions));
    }
}

