/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.ColumnProfile;
import org.openmetadata.schema.type.SystemProfile;
import org.openmetadata.schema.type.TableProfile;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"tableProfile", "columnProfile", "systemProfile"})
public class CreateTableProfile {
    @JsonProperty(value="tableProfile")
    @JsonPropertyDescription(value="This schema defines the type to capture the table's data profile.")
    @Valid
    @NotNull
    private TableProfile tableProfile;
    @JsonProperty(value="columnProfile")
    @JsonPropertyDescription(value="List of local column profiles of the table.")
    @Valid
    private List<ColumnProfile> columnProfile = new ArrayList<ColumnProfile>();
    @JsonProperty(value="systemProfile")
    @JsonPropertyDescription(value="List of system profiles for the table.")
    @Valid
    private List<SystemProfile> systemProfile = new ArrayList<SystemProfile>();

    @JsonProperty(value="tableProfile")
    public TableProfile getTableProfile() {
        return this.tableProfile;
    }

    @JsonProperty(value="tableProfile")
    public void setTableProfile(TableProfile tableProfile) {
        this.tableProfile = tableProfile;
    }

    public CreateTableProfile withTableProfile(TableProfile tableProfile) {
        this.tableProfile = tableProfile;
        return this;
    }

    @JsonProperty(value="columnProfile")
    public List<ColumnProfile> getColumnProfile() {
        return this.columnProfile;
    }

    @JsonProperty(value="columnProfile")
    public void setColumnProfile(List<ColumnProfile> columnProfile) {
        this.columnProfile = columnProfile;
    }

    public CreateTableProfile withColumnProfile(List<ColumnProfile> columnProfile) {
        this.columnProfile = columnProfile;
        return this;
    }

    @JsonProperty(value="systemProfile")
    public List<SystemProfile> getSystemProfile() {
        return this.systemProfile;
    }

    @JsonProperty(value="systemProfile")
    public void setSystemProfile(List<SystemProfile> systemProfile) {
        this.systemProfile = systemProfile;
    }

    public CreateTableProfile withSystemProfile(List<SystemProfile> systemProfile) {
        this.systemProfile = systemProfile;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateTableProfile.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("tableProfile");
        sb.append('=');
        sb.append(this.tableProfile == null ? "<null>" : this.tableProfile);
        sb.append(',');
        sb.append("columnProfile");
        sb.append('=');
        sb.append(this.columnProfile == null ? "<null>" : this.columnProfile);
        sb.append(',');
        sb.append("systemProfile");
        sb.append('=');
        sb.append(this.systemProfile == null ? "<null>" : this.systemProfile);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.columnProfile == null ? 0 : this.columnProfile.hashCode());
        result = result * 31 + (this.tableProfile == null ? 0 : this.tableProfile.hashCode());
        result = result * 31 + (this.systemProfile == null ? 0 : this.systemProfile.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateTableProfile)) {
            return false;
        }
        CreateTableProfile rhs = (CreateTableProfile)other;
        return (this.columnProfile == rhs.columnProfile || this.columnProfile != null && this.columnProfile.equals(rhs.columnProfile)) && (this.tableProfile == rhs.tableProfile || this.tableProfile != null && this.tableProfile.equals(rhs.tableProfile)) && (this.systemProfile == rhs.systemProfile || this.systemProfile != null && this.systemProfile.equals(rhs.systemProfile));
    }
}

