/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.Task;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "pipelineUrl", "concurrency", "pipelineLocation", "startDate", "tasks", "tags", "owner", "service", "extension"})
public class CreatePipeline
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of a table. Expected to be unique within a database.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this Pipeline. It could be title or label from the source services.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="pipelineUrl")
    @JsonPropertyDescription(value="Pipeline URL suffix to visit/manage. This URL points to respective pipeline service UI")
    private String pipelineUrl;
    @JsonProperty(value="concurrency")
    @JsonPropertyDescription(value="Concurrency of the Pipeline")
    private Integer concurrency;
    @JsonProperty(value="pipelineLocation")
    @JsonPropertyDescription(value="Pipeline Code Location")
    private String pipelineLocation;
    @JsonProperty(value="startDate")
    @JsonPropertyDescription(value="Date and time in ISO 8601 format. Example - '2018-11-13T20:20:39+00:00'.")
    private Date startDate;
    @JsonProperty(value="tasks")
    @JsonPropertyDescription(value="All the tasks that are part of pipeline.")
    @Valid
    private List<Task> tasks = null;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this Pipeline.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    @NotNull
    private @Size(min=1, max=256) @NotNull String service;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Entity extension data with custom attributes added to the entity.")
    private Object extension;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreatePipeline withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreatePipeline withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreatePipeline withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="pipelineUrl")
    public String getPipelineUrl() {
        return this.pipelineUrl;
    }

    @JsonProperty(value="pipelineUrl")
    public void setPipelineUrl(String pipelineUrl) {
        this.pipelineUrl = pipelineUrl;
    }

    public CreatePipeline withPipelineUrl(String pipelineUrl) {
        this.pipelineUrl = pipelineUrl;
        return this;
    }

    @JsonProperty(value="concurrency")
    public Integer getConcurrency() {
        return this.concurrency;
    }

    @JsonProperty(value="concurrency")
    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    public CreatePipeline withConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    @JsonProperty(value="pipelineLocation")
    public String getPipelineLocation() {
        return this.pipelineLocation;
    }

    @JsonProperty(value="pipelineLocation")
    public void setPipelineLocation(String pipelineLocation) {
        this.pipelineLocation = pipelineLocation;
    }

    public CreatePipeline withPipelineLocation(String pipelineLocation) {
        this.pipelineLocation = pipelineLocation;
        return this;
    }

    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public CreatePipeline withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty(value="tasks")
    public List<Task> getTasks() {
        return this.tasks;
    }

    @JsonProperty(value="tasks")
    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public CreatePipeline withTasks(List<Task> tasks) {
        this.tasks = tasks;
        return this;
    }

    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreatePipeline withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreatePipeline withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="service")
    public String getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(String service) {
        this.service = service;
    }

    public CreatePipeline withService(String service) {
        this.service = service;
        return this;
    }

    @Override
    @JsonProperty(value="extension")
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreatePipeline withExtension(Object extension) {
        this.extension = extension;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreatePipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("pipelineUrl");
        sb.append('=');
        sb.append(this.pipelineUrl == null ? "<null>" : this.pipelineUrl);
        sb.append(',');
        sb.append("concurrency");
        sb.append('=');
        sb.append(this.concurrency == null ? "<null>" : this.concurrency);
        sb.append(',');
        sb.append("pipelineLocation");
        sb.append('=');
        sb.append(this.pipelineLocation == null ? "<null>" : this.pipelineLocation);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("tasks");
        sb.append('=');
        sb.append(this.tasks == null ? "<null>" : this.tasks);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("service");
        sb.append('=');
        sb.append(this.service == null ? "<null>" : this.service);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.pipelineUrl == null ? 0 : this.pipelineUrl.hashCode());
        result = result * 31 + (this.concurrency == null ? 0 : this.concurrency.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.pipelineLocation == null ? 0 : this.pipelineLocation.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.tasks == null ? 0 : this.tasks.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreatePipeline)) {
            return false;
        }
        CreatePipeline rhs = (CreatePipeline)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.extension == rhs.extension || this.extension != null && this.extension.equals(rhs.extension)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.pipelineUrl == rhs.pipelineUrl || this.pipelineUrl != null && this.pipelineUrl.equals(rhs.pipelineUrl)) && (this.concurrency == rhs.concurrency || this.concurrency != null && this.concurrency.equals(rhs.concurrency)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.service == rhs.service || this.service != null && this.service.equals(rhs.service)) && (this.pipelineLocation == rhs.pipelineLocation || this.pipelineLocation != null && this.pipelineLocation.equals(rhs.pipelineLocation)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate)) && (this.tasks == rhs.tasks || this.tasks != null && this.tasks.equals(rhs.tasks));
    }
}

