/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.type.ChartType;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "chartType", "chartUrl", "tables", "tags", "owner", "service"})
public class CreateChart
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this Chart. It could be title or label from the source services")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="chartType")
    @JsonPropertyDescription(value="This schema defines the type used for describing different types of charts.")
    private ChartType chartType;
    @JsonProperty(value="chartUrl")
    @JsonPropertyDescription(value="Chart URL suffix from its service.")
    private String chartUrl;
    @JsonProperty(value="tables")
    @JsonPropertyDescription(value="Link to list of table fully qualified names used in this chart.")
    @Valid
    private List<String> tables = new ArrayList<String>();
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this chart")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    @NotNull
    private @Size(min=1, max=256) @NotNull String service;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateChart withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateChart withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateChart withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="chartType")
    public ChartType getChartType() {
        return this.chartType;
    }

    @JsonProperty(value="chartType")
    public void setChartType(ChartType chartType) {
        this.chartType = chartType;
    }

    public CreateChart withChartType(ChartType chartType) {
        this.chartType = chartType;
        return this;
    }

    @JsonProperty(value="chartUrl")
    public String getChartUrl() {
        return this.chartUrl;
    }

    @JsonProperty(value="chartUrl")
    public void setChartUrl(String chartUrl) {
        this.chartUrl = chartUrl;
    }

    public CreateChart withChartUrl(String chartUrl) {
        this.chartUrl = chartUrl;
        return this;
    }

    @JsonProperty(value="tables")
    public List<String> getTables() {
        return this.tables;
    }

    @JsonProperty(value="tables")
    public void setTables(List<String> tables) {
        this.tables = tables;
    }

    public CreateChart withTables(List<String> tables) {
        this.tables = tables;
        return this;
    }

    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateChart withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateChart withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="service")
    public String getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(String service) {
        this.service = service;
    }

    public CreateChart withService(String service) {
        this.service = service;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateChart.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("chartType");
        sb.append('=');
        sb.append(this.chartType == null ? "<null>" : this.chartType);
        sb.append(',');
        sb.append("chartUrl");
        sb.append('=');
        sb.append(this.chartUrl == null ? "<null>" : this.chartUrl);
        sb.append(',');
        sb.append("tables");
        sb.append('=');
        sb.append(this.tables == null ? "<null>" : this.tables);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("service");
        sb.append('=');
        sb.append(this.service == null ? "<null>" : this.service);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.tables == null ? 0 : this.tables.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.chartType == null ? 0 : this.chartType.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.chartUrl == null ? 0 : this.chartUrl.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateChart)) {
            return false;
        }
        CreateChart rhs = (CreateChart)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.tables == rhs.tables || this.tables != null && this.tables.equals(rhs.tables)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.service == rhs.service || this.service != null && this.service.equals(rhs.service)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.chartType == rhs.chartType || this.chartType != null && this.chartType.equals((Object)rhs.chartType)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.chartUrl == rhs.chartUrl || this.chartUrl != null && this.chartUrl.equals(rhs.chartUrl)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags));
    }
}

