/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.entity.type.Category;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "nameSpace", "category", "schema"})
public class CreateType
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the property or entity types. Note a property name must be unique for an entity. Property name must follow camelCase naming adopted by openMetadata - must start with lower case with no space, underscore, or dots.")
    @Pattern(regexp="^(?U)[\\w]+$")
    @NotNull
    private @Pattern(regexp="^(?U)[\\w]+$") @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this Type.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    @NotNull
    private String description;
    @JsonProperty(value="nameSpace")
    @JsonPropertyDescription(value="Namespace or group to which this type belongs to.")
    @NotNull
    private String nameSpace = "custom";
    @JsonProperty(value="category")
    @JsonPropertyDescription(value="Metadata category to which a type belongs to.")
    private Category category;
    @JsonProperty(value="schema")
    @JsonPropertyDescription(value="JSON schema encoded as string. This will be used to validate the JSON fields using this schema.")
    @NotNull
    private String schema;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateType withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateType withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateType withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="nameSpace")
    public String getNameSpace() {
        return this.nameSpace;
    }

    @JsonProperty(value="nameSpace")
    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public CreateType withNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    @JsonProperty(value="category")
    public Category getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    public void setCategory(Category category) {
        this.category = category;
    }

    public CreateType withCategory(Category category) {
        this.category = category;
        return this;
    }

    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public CreateType withSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateType.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("nameSpace");
        sb.append('=');
        sb.append(this.nameSpace == null ? "<null>" : this.nameSpace);
        sb.append(',');
        sb.append("category");
        sb.append('=');
        sb.append(this.category == null ? "<null>" : this.category);
        sb.append(',');
        sb.append("schema");
        sb.append('=');
        sb.append(this.schema == null ? "<null>" : this.schema);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.schema == null ? 0 : this.schema.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.nameSpace == null ? 0 : this.nameSpace.hashCode());
        result = result * 31 + (this.category == null ? 0 : this.category.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateType)) {
            return false;
        }
        CreateType rhs = (CreateType)other;
        return (this.schema == rhs.schema || this.schema != null && this.schema.equals(rhs.schema)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.nameSpace == rhs.nameSpace || this.nameSpace != null && this.nameSpace.equals(rhs.nameSpace)) && (this.category == rhs.category || this.category != null && this.category.equals((Object)rhs.category));
    }
}

