/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.IndexMappingLanguage;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"publisherType", "runMode", "entities", "recreateIndex", "batchSize", "flushIntervalInSec", "searchIndexMappingLanguage"})
public class CreateEventPublisherJob {
    @JsonProperty(value="publisherType")
    @JsonPropertyDescription(value="This schema event Publisher Types")
    @NotNull
    private PublisherType publisherType;
    @JsonProperty(value="runMode")
    @JsonPropertyDescription(value="This schema publisher run modes.")
    @NotNull
    private RunMode runMode;
    @JsonProperty(value="entities")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="List of Entities to Reindex")
    @Valid
    private Set<String> entities = new LinkedHashSet<String>(Arrays.asList("all"));
    @JsonProperty(value="recreateIndex")
    @JsonPropertyDescription(value="This schema publisher run modes.")
    private Boolean recreateIndex = false;
    @JsonProperty(value="batchSize")
    @JsonPropertyDescription(value="Maximum number of events sent in a batch (Default 10).")
    private Integer batchSize = 100;
    @JsonProperty(value="flushIntervalInSec")
    @JsonPropertyDescription(value="Maximum time to wait before sending request to ES in seconds(Default 30)")
    private Integer flushIntervalInSec = 30;
    @JsonProperty(value="searchIndexMappingLanguage")
    @JsonPropertyDescription(value="This schema defines the language options available for search index mappings.")
    private IndexMappingLanguage searchIndexMappingLanguage = IndexMappingLanguage.fromValue("EN");

    @JsonProperty(value="publisherType")
    public PublisherType getPublisherType() {
        return this.publisherType;
    }

    @JsonProperty(value="publisherType")
    public void setPublisherType(PublisherType publisherType) {
        this.publisherType = publisherType;
    }

    public CreateEventPublisherJob withPublisherType(PublisherType publisherType) {
        this.publisherType = publisherType;
        return this;
    }

    @JsonProperty(value="runMode")
    public RunMode getRunMode() {
        return this.runMode;
    }

    @JsonProperty(value="runMode")
    public void setRunMode(RunMode runMode) {
        this.runMode = runMode;
    }

    public CreateEventPublisherJob withRunMode(RunMode runMode) {
        this.runMode = runMode;
        return this;
    }

    @JsonProperty(value="entities")
    public Set<String> getEntities() {
        return this.entities;
    }

    @JsonProperty(value="entities")
    public void setEntities(Set<String> entities) {
        this.entities = entities;
    }

    public CreateEventPublisherJob withEntities(Set<String> entities) {
        this.entities = entities;
        return this;
    }

    @JsonProperty(value="recreateIndex")
    public Boolean getRecreateIndex() {
        return this.recreateIndex;
    }

    @JsonProperty(value="recreateIndex")
    public void setRecreateIndex(Boolean recreateIndex) {
        this.recreateIndex = recreateIndex;
    }

    public CreateEventPublisherJob withRecreateIndex(Boolean recreateIndex) {
        this.recreateIndex = recreateIndex;
        return this;
    }

    @JsonProperty(value="batchSize")
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="batchSize")
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public CreateEventPublisherJob withBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @JsonProperty(value="flushIntervalInSec")
    public Integer getFlushIntervalInSec() {
        return this.flushIntervalInSec;
    }

    @JsonProperty(value="flushIntervalInSec")
    public void setFlushIntervalInSec(Integer flushIntervalInSec) {
        this.flushIntervalInSec = flushIntervalInSec;
    }

    public CreateEventPublisherJob withFlushIntervalInSec(Integer flushIntervalInSec) {
        this.flushIntervalInSec = flushIntervalInSec;
        return this;
    }

    @JsonProperty(value="searchIndexMappingLanguage")
    public IndexMappingLanguage getSearchIndexMappingLanguage() {
        return this.searchIndexMappingLanguage;
    }

    @JsonProperty(value="searchIndexMappingLanguage")
    public void setSearchIndexMappingLanguage(IndexMappingLanguage searchIndexMappingLanguage) {
        this.searchIndexMappingLanguage = searchIndexMappingLanguage;
    }

    public CreateEventPublisherJob withSearchIndexMappingLanguage(IndexMappingLanguage searchIndexMappingLanguage) {
        this.searchIndexMappingLanguage = searchIndexMappingLanguage;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateEventPublisherJob.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("publisherType");
        sb.append('=');
        sb.append(this.publisherType == null ? "<null>" : this.publisherType);
        sb.append(',');
        sb.append("runMode");
        sb.append('=');
        sb.append(this.runMode == null ? "<null>" : this.runMode);
        sb.append(',');
        sb.append("entities");
        sb.append('=');
        sb.append(this.entities == null ? "<null>" : this.entities);
        sb.append(',');
        sb.append("recreateIndex");
        sb.append('=');
        sb.append(this.recreateIndex == null ? "<null>" : this.recreateIndex);
        sb.append(',');
        sb.append("batchSize");
        sb.append('=');
        sb.append(this.batchSize == null ? "<null>" : this.batchSize);
        sb.append(',');
        sb.append("flushIntervalInSec");
        sb.append('=');
        sb.append(this.flushIntervalInSec == null ? "<null>" : this.flushIntervalInSec);
        sb.append(',');
        sb.append("searchIndexMappingLanguage");
        sb.append('=');
        sb.append(this.searchIndexMappingLanguage == null ? "<null>" : this.searchIndexMappingLanguage);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.publisherType == null ? 0 : this.publisherType.hashCode());
        result = result * 31 + (this.entities == null ? 0 : this.entities.hashCode());
        result = result * 31 + (this.searchIndexMappingLanguage == null ? 0 : this.searchIndexMappingLanguage.hashCode());
        result = result * 31 + (this.recreateIndex == null ? 0 : this.recreateIndex.hashCode());
        result = result * 31 + (this.batchSize == null ? 0 : this.batchSize.hashCode());
        result = result * 31 + (this.flushIntervalInSec == null ? 0 : this.flushIntervalInSec.hashCode());
        result = result * 31 + (this.runMode == null ? 0 : this.runMode.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateEventPublisherJob)) {
            return false;
        }
        CreateEventPublisherJob rhs = (CreateEventPublisherJob)other;
        return (this.publisherType == rhs.publisherType || this.publisherType != null && this.publisherType.equals((Object)rhs.publisherType)) && (this.entities == rhs.entities || this.entities != null && this.entities.equals(rhs.entities)) && (this.searchIndexMappingLanguage == rhs.searchIndexMappingLanguage || this.searchIndexMappingLanguage != null && this.searchIndexMappingLanguage.equals((Object)rhs.searchIndexMappingLanguage)) && (this.recreateIndex == rhs.recreateIndex || this.recreateIndex != null && this.recreateIndex.equals(rhs.recreateIndex)) && (this.batchSize == rhs.batchSize || this.batchSize != null && this.batchSize.equals(rhs.batchSize)) && (this.flushIntervalInSec == rhs.flushIntervalInSec || this.flushIntervalInSec != null && this.flushIntervalInSec.equals(rhs.flushIntervalInSec)) && (this.runMode == rhs.runMode || this.runMode != null && this.runMode.equals((Object)rhs.runMode));
    }

    public static enum RunMode {
        STREAM("stream"),
        BATCH("batch");

        private final String value;
        private static final Map<String, RunMode> CONSTANTS;

        private RunMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static RunMode fromValue(String value) {
            RunMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, RunMode>();
            for (RunMode c : RunMode.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum PublisherType {
        ELASTIC_SEARCH("elasticSearch"),
        KAFKA("kafka");

        private final String value;
        private static final Map<String, PublisherType> CONSTANTS;

        private PublisherType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static PublisherType fromValue(String value) {
            PublisherType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, PublisherType>();
            for (PublisherType c : PublisherType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

