/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.type.ProviderType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "botUser", "description", "provider"})
public class CreateBot
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Login name of the user, typically the user ID from an identity provider. Example - uid from LDAP.")
    @Pattern(regexp="^(?U)[\\w\\-.]+$")
    @Size(min=1, max=64)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w\\-.]+$") @Size(min=1, max=64) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Name used for display purposes. Example 'FirstName LastName'.")
    private String displayName;
    @JsonProperty(value="botUser")
    @JsonPropertyDescription(value="Bot user name created for this bot on behalf of which the bot performs all the operations, such as updating description, responding on the conversation threads, etc.")
    @NotNull
    private String botUser;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Description of the bot.")
    private String description;
    @JsonProperty(value="provider")
    @JsonPropertyDescription(value="Type of provider of an entity. Some entities are provided by the `system`. Some are are entities created and provided by the `user`. Typically `system` provide entities can't be deleted and can only be disabled.")
    private ProviderType provider = ProviderType.fromValue("user");

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateBot withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateBot withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty(value="botUser")
    public String getBotUser() {
        return this.botUser;
    }

    @JsonProperty(value="botUser")
    public void setBotUser(String botUser) {
        this.botUser = botUser;
    }

    public CreateBot withBotUser(String botUser) {
        this.botUser = botUser;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateBot withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="provider")
    public ProviderType getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    public void setProvider(ProviderType provider) {
        this.provider = provider;
    }

    public CreateBot withProvider(ProviderType provider) {
        this.provider = provider;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateBot.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("botUser");
        sb.append('=');
        sb.append(this.botUser == null ? "<null>" : this.botUser);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("provider");
        sb.append('=');
        sb.append(this.provider == null ? "<null>" : this.provider);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.botUser == null ? 0 : this.botUser.hashCode());
        result = result * 31 + (this.provider == null ? 0 : this.provider.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateBot)) {
            return false;
        }
        CreateBot rhs = (CreateBot)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.botUser == rhs.botUser || this.botUser != null && this.botUser.equals(rhs.botUser)) && (this.provider == rhs.provider || this.provider != null && this.provider.equals((Object)rhs.provider)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName));
    }
}

