/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.analytics;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"fullUrl", "url", "hostname", "sessionId", "eventType", "eventValue"})
public class CustomEvent {
    @JsonProperty(value="fullUrl")
    @JsonPropertyDescription(value="complete URL of the page")
    private String fullUrl;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="url part after the domain specification")
    private String url;
    @JsonProperty(value="hostname")
    @JsonPropertyDescription(value="domain name")
    private String hostname;
    @JsonProperty(value="sessionId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID sessionId;
    @JsonProperty(value="eventType")
    @JsonPropertyDescription(value="Type of events that can be performed")
    private CustomEventTypes eventType;
    @JsonProperty(value="eventValue")
    @JsonPropertyDescription(value="Value of the event")
    private String eventValue;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="fullUrl")
    public String getFullUrl() {
        return this.fullUrl;
    }

    @JsonProperty(value="fullUrl")
    public void setFullUrl(String fullUrl) {
        this.fullUrl = fullUrl;
    }

    public CustomEvent withFullUrl(String fullUrl) {
        this.fullUrl = fullUrl;
        return this;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    public CustomEvent withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty(value="hostname")
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty(value="hostname")
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public CustomEvent withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @JsonProperty(value="sessionId")
    public UUID getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="sessionId")
    public void setSessionId(UUID sessionId) {
        this.sessionId = sessionId;
    }

    public CustomEvent withSessionId(UUID sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @JsonProperty(value="eventType")
    public CustomEventTypes getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="eventType")
    public void setEventType(CustomEventTypes eventType) {
        this.eventType = eventType;
    }

    public CustomEvent withEventType(CustomEventTypes eventType) {
        this.eventType = eventType;
        return this;
    }

    @JsonProperty(value="eventValue")
    public String getEventValue() {
        return this.eventValue;
    }

    @JsonProperty(value="eventValue")
    public void setEventValue(String eventValue) {
        this.eventValue = eventValue;
    }

    public CustomEvent withEventValue(String eventValue) {
        this.eventValue = eventValue;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public CustomEvent withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CustomEvent.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("fullUrl");
        sb.append('=');
        sb.append(this.fullUrl == null ? "<null>" : this.fullUrl);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("hostname");
        sb.append('=');
        sb.append(this.hostname == null ? "<null>" : this.hostname);
        sb.append(',');
        sb.append("sessionId");
        sb.append('=');
        sb.append(this.sessionId == null ? "<null>" : this.sessionId);
        sb.append(',');
        sb.append("eventType");
        sb.append('=');
        sb.append(this.eventType == null ? "<null>" : this.eventType);
        sb.append(',');
        sb.append("eventValue");
        sb.append('=');
        sb.append(this.eventValue == null ? "<null>" : this.eventValue);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = result * 31 + (this.eventValue == null ? 0 : this.eventValue.hashCode());
        result = result * 31 + (this.fullUrl == null ? 0 : this.fullUrl.hashCode());
        result = result * 31 + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        result = result * 31 + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CustomEvent)) {
            return false;
        }
        CustomEvent rhs = (CustomEvent)other;
        return (this.hostname == rhs.hostname || this.hostname != null && this.hostname.equals(rhs.hostname)) && (this.eventValue == rhs.eventValue || this.eventValue != null && this.eventValue.equals(rhs.eventValue)) && (this.fullUrl == rhs.fullUrl || this.fullUrl != null && this.fullUrl.equals(rhs.fullUrl)) && (this.sessionId == rhs.sessionId || this.sessionId != null && this.sessionId.equals(rhs.sessionId)) && (this.eventType == rhs.eventType || this.eventType != null && this.eventType.equals((Object)rhs.eventType)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url));
    }

    public static enum CustomEventTypes {
        CLICK("CLICK");

        private final String value;
        private static final Map<String, CustomEventTypes> CONSTANTS;

        private CustomEventTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CustomEventTypes fromValue(String value) {
            CustomEventTypes constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CustomEventTypes>();
            for (CustomEventTypes c : CustomEventTypes.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

