/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.catalog.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"entityId", "acs", "spX509Certificate", "spPrivateKey", "callback"})
public class ServiceProviderConfig {
    @JsonProperty(value="entityId")
    @JsonPropertyDescription(value="Service Provider Entity ID.")
    @NotNull
    private String entityId;
    @JsonProperty(value="acs")
    @JsonPropertyDescription(value="Assertion Consumer URL.")
    @NotNull
    private String acs;
    @JsonProperty(value="spX509Certificate")
    @JsonPropertyDescription(value="X509 Certificate ")
    private String spX509Certificate;
    @JsonProperty(value="spPrivateKey")
    @JsonPropertyDescription(value="Sp Private Key for Signing and Encryption Only")
    private String spPrivateKey;
    @JsonProperty(value="callback")
    @JsonPropertyDescription(value="Service Provider Entity ID usually same as the SSO login URL.")
    @NotNull
    private String callback;

    @JsonProperty(value="entityId")
    public String getEntityId() {
        return this.entityId;
    }

    @JsonProperty(value="entityId")
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public ServiceProviderConfig withEntityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    @JsonProperty(value="acs")
    public String getAcs() {
        return this.acs;
    }

    @JsonProperty(value="acs")
    public void setAcs(String acs) {
        this.acs = acs;
    }

    public ServiceProviderConfig withAcs(String acs) {
        this.acs = acs;
        return this;
    }

    @JsonProperty(value="spX509Certificate")
    public String getSpX509Certificate() {
        return this.spX509Certificate;
    }

    @JsonProperty(value="spX509Certificate")
    public void setSpX509Certificate(String spX509Certificate) {
        this.spX509Certificate = spX509Certificate;
    }

    public ServiceProviderConfig withSpX509Certificate(String spX509Certificate) {
        this.spX509Certificate = spX509Certificate;
        return this;
    }

    @JsonProperty(value="spPrivateKey")
    public String getSpPrivateKey() {
        return this.spPrivateKey;
    }

    @JsonProperty(value="spPrivateKey")
    public void setSpPrivateKey(String spPrivateKey) {
        this.spPrivateKey = spPrivateKey;
    }

    public ServiceProviderConfig withSpPrivateKey(String spPrivateKey) {
        this.spPrivateKey = spPrivateKey;
        return this;
    }

    @JsonProperty(value="callback")
    public String getCallback() {
        return this.callback;
    }

    @JsonProperty(value="callback")
    public void setCallback(String callback) {
        this.callback = callback;
    }

    public ServiceProviderConfig withCallback(String callback) {
        this.callback = callback;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ServiceProviderConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("entityId");
        sb.append('=');
        sb.append(this.entityId == null ? "<null>" : this.entityId);
        sb.append(',');
        sb.append("acs");
        sb.append('=');
        sb.append(this.acs == null ? "<null>" : this.acs);
        sb.append(',');
        sb.append("spX509Certificate");
        sb.append('=');
        sb.append(this.spX509Certificate == null ? "<null>" : this.spX509Certificate);
        sb.append(',');
        sb.append("spPrivateKey");
        sb.append('=');
        sb.append(this.spPrivateKey == null ? "<null>" : this.spPrivateKey);
        sb.append(',');
        sb.append("callback");
        sb.append('=');
        sb.append(this.callback == null ? "<null>" : this.callback);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.acs == null ? 0 : this.acs.hashCode());
        result = result * 31 + (this.callback == null ? 0 : this.callback.hashCode());
        result = result * 31 + (this.entityId == null ? 0 : this.entityId.hashCode());
        result = result * 31 + (this.spX509Certificate == null ? 0 : this.spX509Certificate.hashCode());
        result = result * 31 + (this.spPrivateKey == null ? 0 : this.spPrivateKey.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ServiceProviderConfig)) {
            return false;
        }
        ServiceProviderConfig rhs = (ServiceProviderConfig)other;
        return (this.acs == rhs.acs || this.acs != null && this.acs.equals(rhs.acs)) && (this.callback == rhs.callback || this.callback != null && this.callback.equals(rhs.callback)) && (this.entityId == rhs.entityId || this.entityId != null && this.entityId.equals(rhs.entityId)) && (this.spX509Certificate == rhs.spX509Certificate || this.spX509Certificate != null && this.spX509Certificate.equals(rhs.spX509Certificate)) && (this.spPrivateKey == rhs.spPrivateKey || this.spPrivateKey != null && this.spPrivateKey.equals(rhs.spPrivateKey));
    }
}

