/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Utils;
import com.tailf.jnc.YangBaseInt;
import com.tailf.jnc.YangException;
import java.math.BigDecimal;

public class YangDecimal64
extends YangBaseInt<BigDecimal> {
    private static final long serialVersionUID = 1L;
    private Integer fractionDigits = null;

    public YangDecimal64(String string, int n) throws YangException {
        super(string);
        this.fractionDigits = n;
        this.setMinMax();
        this.check();
    }

    public YangDecimal64(Number number, int n) throws YangException {
        super(Utils.bigDecimalValueOf(number));
        this.fractionDigits = n;
        this.setMinMax();
    }

    @Override
    public void setValue(String string) throws YangException {
        this.setValue(new BigDecimal(string));
    }

    @Override
    public void setValue(Number number) throws YangException {
        BigDecimal bigDecimal = Utils.bigDecimalValueOf(number);
        super.setValue(bigDecimal);
        this.check();
    }

    private void setMinMax() throws YangException {
        YangException.throwException(this.fractionDigits == null, this);
        BigDecimal bigDecimal = new BigDecimal("2.0").pow(63);
        BigDecimal bigDecimal2 = bigDecimal.negate().movePointLeft(this.fractionDigits);
        bigDecimal = bigDecimal.subtract(BigDecimal.ONE);
        BigDecimal bigDecimal3 = bigDecimal.movePointLeft(this.fractionDigits);
        this.setMinMax(bigDecimal2, bigDecimal3);
    }

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    @Override
    public String toString() {
        return ((BigDecimal)this.value).toPlainString();
    }

    @Override
    public void check() throws YangException {
        boolean bl = this.fractionDigits != null && (this.fractionDigits < 1 || this.fractionDigits > 18);
        YangException.throwException(bl, this);
        super.check();
    }

    @Override
    protected BigDecimal decode(String string) throws NumberFormatException {
        return new BigDecimal(string);
    }

    @Override
    public boolean canEqual(Object object) {
        return object instanceof YangDecimal64;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof YangDecimal64) {
            YangDecimal64 yangDecimal64 = (YangDecimal64)object;
            try {
                this.exact((Number)yangDecimal64.getValue());
                return this.fractionDigits.equals(yangDecimal64.fractionDigits) && yangDecimal64.canEqual(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        return this.fractionDigits == null ? n : n << this.fractionDigits;
    }

    protected YangDecimal64 cloneShallow() throws YangException {
        return new YangDecimal64(this.toString(), (int)this.fractionDigits);
    }
}

