/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Attribute;
import com.tailf.jnc.Element;
import com.tailf.jnc.JNCException;
import com.tailf.jnc.Prefix;
import com.tailf.jnc.PrefixMap;
import java.io.ByteArrayInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLParser {
    protected XMLReader parser;

    public XMLParser() throws JNCException {
        try {
            String string = System.getProperty("java.version");
            this.parser = string.startsWith("1.4") ? XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl") : XMLReaderFactory.createXMLReader();
        }
        catch (Exception exception) {
            throw new JNCException(-5, "failed to initialize parser: " + exception);
        }
    }

    public Element readFile(String string) throws JNCException {
        try {
            ConfHandler confHandler = new ConfHandler();
            this.parser.setContentHandler(confHandler);
            this.parser.parse(string);
            return confHandler.top;
        }
        catch (Exception exception) {
            throw new JNCException(-5, "parse file: " + string + " error: " + exception);
        }
    }

    public Element parse(InputSource inputSource) throws JNCException {
        try {
            ConfHandler confHandler = new ConfHandler();
            this.parser.setContentHandler(confHandler);
            this.parser.parse(inputSource);
            return confHandler.top;
        }
        catch (Exception exception) {
            throw new JNCException(-5, "parse error: " + exception);
        }
    }

    public Element parse(String string) throws JNCException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        InputSource inputSource = new InputSource(byteArrayInputStream);
        return this.parse(inputSource);
    }

    protected void trace(String string) {
        if (Element.debugLevel >= 3) {
            System.err.println("*XMLParser: " + string);
        }
    }

    private class ConfHandler
    extends DefaultHandler {
        public Element current;
        public Element top;
        public PrefixMap prefixes = null;

        private ConfHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Element element = new Element(string, string2);
            element.prefixes = this.prefixes;
            this.prefixes = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string4 = attributes.getLocalName(i);
                String string5 = attributes.getURI(i);
                String string6 = attributes.getValue(i);
                Attribute attribute = new Attribute(string5, string4, string6);
                XMLParser.this.trace("add attr: " + attribute);
                element.addAttr(attribute);
            }
            if (this.current == null) {
                XMLParser.this.trace("add to top: " + element);
                this.top = element;
            } else {
                this.current.addChild(element);
                XMLParser.this.trace("add child: " + element);
            }
            this.current = element;
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (this.current.hasChildren() && this.current.value != null) {
                this.current.value = null;
            }
            this.current = this.current.getParent();
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.current.value == null) {
                this.current.value = "";
            }
            this.current.value = this.current.value + new String(cArray, n, n2);
        }

        @Override
        public void startPrefixMapping(String string, String string2) {
            XMLParser.this.trace("startPrefixMapping: uri=\"" + string2 + "\" prefix=" + string);
            if (this.prefixes == null) {
                this.prefixes = new PrefixMap();
            }
            this.prefixes.add(new Prefix(string, string2));
            XMLParser.this.trace("added prefixmapping: " + string);
        }
    }
}

