/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Element;
import com.tailf.jnc.NodeSet;
import com.tailf.jnc.RpcError;

public class JNCException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected int errorCode;
    protected Object opaqueData = null;
    private RpcError[] rpcErrors;
    public static final int AUTH_FAILED = -1;
    public static final int PATH_ERROR = -3;
    public static final int PATH_CREATE_ERROR = -4;
    public static final int PARSER_ERROR = -5;
    public static final int RPC_REPLY_ERROR = -6;
    public static final int SESSION_ERROR = -7;
    public static final int ELEMENT_ALREADY_IN_USE = -8;
    public static final int ELEMENT_MISSING = -9;
    public static final int NOTIFICATION_ERROR = -10;
    public static final int TIMEOUT_ERROR = -11;
    public static final int REVISION_ERROR = -12;
    public static final int MESSAGE_ID_MISMATCH = -13;

    public JNCException(int n, Object object) {
        this.errorCode = n;
        this.opaqueData = object;
        if (n == -6) {
            Element element = (Element)object;
            try {
                NodeSet nodeSet = element.get("self::rpc-reply/rpc-error");
                if (nodeSet != null) {
                    this.rpcErrors = new RpcError[nodeSet.size()];
                    for (int i = 0; i < nodeSet.size(); ++i) {
                        this.rpcErrors[i] = new RpcError((Element)nodeSet.get(i));
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("rpc-error can't be parsed: " + element.toXMLString());
                exception.printStackTrace();
            }
        }
    }

    @Override
    public String toString() {
        switch (this.errorCode) {
            case -1: {
                return "Authentication failed";
            }
            case -3: {
                return "Error in path: " + this.opaqueData;
            }
            case -4: {
                return "Error in create path: " + this.opaqueData;
            }
            case -5: {
                return "Parse error: " + this.opaqueData;
            }
            case -6: {
                if (this.opaqueData != null) {
                    Element element = (Element)this.opaqueData;
                    return "rpc-reply error: " + element.toXMLString();
                }
                return "rpc-reply error";
            }
            case -7: {
                return "Session error: " + this.opaqueData;
            }
            case -8: {
                return "Element has already been used: " + ((Element)this.opaqueData).name;
            }
            case -9: {
                return "Element does not exists: " + this.opaqueData;
            }
            case -10: {
                return "Notification error: " + this.opaqueData;
            }
            case -11: {
                return "Timeout error: " + this.opaqueData;
            }
            case -12: {
                return "Revision error: " + this.opaqueData;
            }
            case -13: {
                return "Message ID mismatch: " + this.opaqueData;
            }
        }
        return "Internal error: " + this.errorCode;
    }
}

