/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Element;
import com.tailf.jnc.XMLParser;

public abstract class IOSubscriber {
    private boolean rawmode;
    private StringBuffer inb;
    private StringBuffer outb;

    public IOSubscriber(boolean bl) {
        this.inb = new StringBuffer(1024);
        this.outb = new StringBuffer(1024);
        this.rawmode = bl;
    }

    public IOSubscriber() {
    }

    public abstract void input(String var1);

    public abstract void output(String var1);

    void inputChar(int n) {
        char c = (char)n;
        this.inb.append(c);
        if (c == '\n' && this.rawmode) {
            this.input(this.inb.toString());
            this.inb.setLength(0);
        }
    }

    private void xmlFlush(StringBuffer stringBuffer, boolean bl) {
        String string;
        try {
            XMLParser xMLParser = new XMLParser();
            Element element = xMLParser.parse(stringBuffer.toString());
            string = element.toXMLString();
            stringBuffer.setLength(0);
        }
        catch (Exception exception) {
            string = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        if (bl) {
            this.input(string);
        } else {
            this.output(string);
        }
    }

    void inputFlush(String string) {
        if (!this.rawmode) {
            this.xmlFlush(this.inb, true);
        } else {
            this.input(this.inb.toString() + string + "\n");
            this.inb.setLength(0);
        }
    }

    void outputFlush(String string) {
        if (!this.rawmode) {
            this.xmlFlush(this.outb, false);
        } else {
            this.output(this.outb.toString() + string + "\n");
            this.outb.setLength(0);
        }
    }

    private void outputChar(char c) {
        this.outb.append(c);
        if (c == '\n' && this.rawmode) {
            this.output(this.outb.toString());
            this.outb.setLength(0);
        }
    }

    void outputPrint(int n) {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(n);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            this.outputChar(stringBuffer.charAt(i));
        }
    }

    void outputPrint(String string) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            this.outputChar(stringBuffer.charAt(i));
        }
    }

    void outputPrintln(String string) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(string);
        stringBuffer.append('\n');
        for (int i = 0; i < stringBuffer.length(); ++i) {
            this.outputChar(stringBuffer.charAt(i));
        }
    }

    void outputPrintln(int n) {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(n);
        stringBuffer.append('\n');
        for (int i = 0; i < stringBuffer.length(); ++i) {
            this.outputChar(stringBuffer.charAt(i));
        }
    }
}

