/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Element;
import com.tailf.jnc.NodeSet;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationMergeHandler {
    public NodeSet updateConfiguration(NodeSet nodeSet, NodeSet nodeSet2, String string) {
        boolean bl;
        List<PathComponent> list = this.splitPathIntoComponents(string);
        if (list.isEmpty() || list.get(0).name.isEmpty()) {
            return nodeSet2;
        }
        Element element = this.findDeepestElement(nodeSet, list);
        if (null == element) {
            this.copyAllElementsToNodeSet(nodeSet, nodeSet2);
            return nodeSet;
        }
        int n = this.determineElementDepth(element);
        boolean bl2 = n == list.size();
        Element element2 = this.identifySubFragmentToBeAdded(nodeSet2, list, n);
        boolean bl3 = bl = null != element2;
        if (bl2) {
            Element element3 = this.removeElementAndReturnItsParent(nodeSet, element);
            if (bl) {
                this.addElement(nodeSet, element3, element2);
            } else {
                this.removeEmptyParents(nodeSet, element3);
            }
        } else if (bl) {
            this.addElement(nodeSet, element, element2);
        }
        return nodeSet;
    }

    private void removeEmptyParents(NodeSet nodeSet, Element element) {
        Element element2 = element;
        while (element2 != null && element2.getChildren().size() == 0) {
            element2 = this.removeElementAndReturnItsParent(nodeSet, element2);
        }
    }

    private Element identifySubFragmentToBeAdded(NodeSet nodeSet, List<PathComponent> list, int n) {
        Element element = this.findDeepestElement(nodeSet, list);
        if (null != element) {
            int n2 = this.determineElementDepth(element);
            int n3 = n2 - n;
            while (n3-- > 1) {
                element = element.getParent();
            }
        }
        return element;
    }

    private void copyAllElementsToNodeSet(NodeSet nodeSet, NodeSet nodeSet2) {
        for (Element element : nodeSet2) {
            nodeSet.add(element);
        }
    }

    private void addElement(NodeSet nodeSet, Element element, Element element2) {
        if (null != element) {
            element.addChild(element2);
        } else {
            nodeSet.add(element2);
        }
    }

    private Element removeElementAndReturnItsParent(NodeSet nodeSet, Element element) {
        Element element2 = element.getParent();
        if (null != element2) {
            element2.deleteChild(element);
        } else {
            nodeSet.removeMember(element);
        }
        return element2;
    }

    private int determineElementDepth(Element element) {
        int n = 0;
        for (Element element2 = element; element2 != null; element2 = element2.getParent()) {
            ++n;
        }
        return n;
    }

    private Element findDeepestElement(NodeSet nodeSet, List<PathComponent> list) {
        Element element = null;
        NodeSet nodeSet2 = nodeSet;
        for (PathComponent pathComponent : list) {
            NodeSet nodeSet3 = nodeSet2;
            nodeSet2 = null;
            for (Element element2 : nodeSet3) {
                if (!this.isMatchingElement(element2, pathComponent)) continue;
                element = element2;
                nodeSet2 = element2.getChildren();
                break;
            }
            if (nodeSet2 != null) continue;
            break;
        }
        return element;
    }

    private List<PathComponent> splitPathIntoComponents(String string) {
        ArrayList<PathComponent> arrayList = new ArrayList<PathComponent>();
        if (string != null) {
            byte[] byArray = string.getBytes();
            int n = 0;
            while (n < string.length() && byArray[n] == 47) {
                int n2 = this.scanName(byArray, ++n);
                PathComponent pathComponent = new PathComponent(new String(byArray, n, n2 - n));
                arrayList.add(pathComponent);
                n = this.scanAndAddKeys(byArray, n2, pathComponent);
            }
        }
        return arrayList;
    }

    private int scanName(byte[] byArray, int n) {
        int n2;
        for (n2 = n; n2 < byArray.length && byArray[n2] != 47 && byArray[n2] != 91; ++n2) {
        }
        return n2;
    }

    private int scanAndAddKeys(byte[] byArray, int n, PathComponent pathComponent) {
        int n2 = n;
        while (n2 < byArray.length) {
            if (byArray[n2] == 91) {
                int n3;
                String string = "";
                byte by = 0;
                int n4 = 0;
                for (n3 = ++n2; n3 < byArray.length && byArray[n3] != 61 && byArray[n3] != 93; ++n3) {
                }
                if (byArray[n3] == 61) {
                    string = new String(byArray, n2, n3 - n2);
                    n3 = n2 = n3 + 1;
                }
                while (n3 < byArray.length && (by != 0 || byArray[n3] != 93)) {
                    if (byArray[n3] == 34 || byArray[n3] == 39) {
                        if (by == 0) {
                            by = byArray[n3];
                        } else {
                            by = 0;
                            n4 = 1;
                        }
                    }
                    ++n3;
                }
                String string2 = new String(byArray, n2 + n4, n3 - n2 - 2 * n4);
                pathComponent.addKey(string, string2);
                n2 = n3 + 1;
                continue;
            }
            return n2;
        }
        return n2;
    }

    private boolean isMatchingElement(Element element, PathComponent pathComponent) {
        return element != null && pathComponent != null && element.name.equals(pathComponent.name) && this.areMatchingKeys(element.getChildren(), pathComponent.keys);
    }

    private boolean areMatchingKeys(NodeSet nodeSet, List<Key> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        if (nodeSet == null || nodeSet.size() < list.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (nodeSet.getElement((int)i).name.equals(list.get(i).name) && nodeSet.getElement(i).getValue().toString().equals(list.get(i).value)) continue;
            return false;
        }
        return true;
    }

    private class PathComponent {
        private final String name;
        private final List<Key> keys = new ArrayList<Key>();

        public PathComponent(String string) {
            this.name = string;
        }

        public void addKey(String string, String string2) {
            this.keys.add(new Key(string, string2));
        }

        public String toString() {
            String string = this.name;
            for (Key key : this.keys) {
                string = string + "[" + key.name + "='" + key.value + "']";
            }
            return string;
        }
    }

    private static class Key {
        private final String name;
        private final String value;

        public Key(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

