/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Element;
import com.tailf.jnc.Transport;
import java.io.Serializable;

public class Attribute
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EQUALS_QUOTE = "=\"";
    public static final String QUOTE = "\"";
    String name;
    String value;
    String ns;

    public Attribute(String string) {
        this.name = string;
        this.value = null;
    }

    public Attribute(String string, String string2) {
        this.name = string;
        this.value = string2;
    }

    public Attribute(String string, String string2, String string3) {
        this.ns = string;
        this.name = string2;
        this.value = string3;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        Attribute.trace("setValue: " + this.name + EQUALS_QUOTE + string + QUOTE);
        this.value = string;
    }

    public Object clone() {
        return new Attribute(this.ns, this.name, this.value);
    }

    public String toString() {
        return "Attribute{name=" + this.name + ",ns=" + this.ns + ",value=" + this.value + "}";
    }

    String toXMLString(Element element) {
        if (this.ns != null && this.ns.length() > 0) {
            String string = element.nsToPrefix(this.ns);
            if (string == null) {
                return "unknown:" + this.name + EQUALS_QUOTE + this.value + QUOTE;
            }
            if (string.length() > 0) {
                return string + ":" + this.name + EQUALS_QUOTE + this.value + QUOTE;
            }
        }
        return this.name + EQUALS_QUOTE + this.value + QUOTE;
    }

    void encode(Transport transport) {
        this.encode(transport, null);
    }

    void encode(Transport transport, Element element) {
        if (this.ns != null && this.ns.length() > 0) {
            String string = element != null ? element.nsToPrefix(this.ns) : Element.defaultPrefixes.nsToPrefix(this.ns);
            if (string == null) {
                if (element != null) {
                    transport.print("unknown:");
                }
                transport.print(this.name + EQUALS_QUOTE + this.value + QUOTE);
                return;
            }
            if (string.length() > 0) {
                transport.print(string + ":" + this.name + EQUALS_QUOTE + this.value + QUOTE);
                return;
            }
        }
        transport.print(this.name + EQUALS_QUOTE + this.value + QUOTE);
    }

    private static void trace(String string) {
        if (Element.debugLevel >= 1) {
            System.err.println("*Attribute: " + string);
        }
    }
}

