/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk.impl;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.onflow.flow.sdk.FlowAccessApi;
import org.onflow.flow.sdk.FlowAccount;
import org.onflow.flow.sdk.FlowAddress;
import org.onflow.flow.sdk.FlowBlock;
import org.onflow.flow.sdk.FlowBlockHeader;
import org.onflow.flow.sdk.FlowChainId;
import org.onflow.flow.sdk.FlowCollection;
import org.onflow.flow.sdk.FlowEventResult;
import org.onflow.flow.sdk.FlowId;
import org.onflow.flow.sdk.FlowScript;
import org.onflow.flow.sdk.FlowScriptResponse;
import org.onflow.flow.sdk.FlowSnapshot;
import org.onflow.flow.sdk.FlowTransaction;
import org.onflow.flow.sdk.FlowTransactionResult;
import org.onflow.protobuf.access.Access;
import org.onflow.protobuf.access.AccessAPIGrpc;
import org.onflow.protobuf.entities.AccountOuterClass;
import org.onflow.protobuf.entities.BlockHeaderOuterClass;
import org.onflow.protobuf.entities.BlockOuterClass;
import org.onflow.protobuf.entities.CollectionOuterClass;
import org.onflow.protobuf.entities.TransactionOuterClass;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J&\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u001e\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J$\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00130*H\u0016J$\u0010+\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0-H\u0016J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020 2\u0006\u0010/\u001a\u000200H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000205H\u0016J\u0012\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J\b\u0010:\u001a\u00020\u0007H\u0016J\u0010\u0010;\u001a\u00020\u00132\u0006\u0010<\u001a\u000207H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/onflow/flow/sdk/impl/FlowAccessApiImpl;", "Lorg/onflow/flow/sdk/FlowAccessApi;", "Ljava/io/Closeable;", "api", "Lorg/onflow/protobuf/access/AccessAPIGrpc$AccessAPIBlockingStub;", "(Lorg/onflow/protobuf/access/AccessAPIGrpc$AccessAPIBlockingStub;)V", "close", "", "executeScriptAtBlockHeight", "Lorg/onflow/flow/sdk/FlowScriptResponse;", "script", "Lorg/onflow/flow/sdk/FlowScript;", "height", "", "arguments", "", "Lcom/google/protobuf/ByteString;", "executeScriptAtBlockId", "blockId", "Lorg/onflow/flow/sdk/FlowId;", "executeScriptAtLatestBlock", "getAccountAtLatestBlock", "Lorg/onflow/flow/sdk/FlowAccount;", "addresss", "Lorg/onflow/flow/sdk/FlowAddress;", "getAccountByAddress", "getAccountByBlockHeight", "getBlockByHeight", "Lorg/onflow/flow/sdk/FlowBlock;", "getBlockById", "id", "getBlockHeaderByHeight", "Lorg/onflow/flow/sdk/FlowBlockHeader;", "getBlockHeaderById", "getCollectionById", "Lorg/onflow/flow/sdk/FlowCollection;", "getEventsForBlockIds", "", "Lorg/onflow/flow/sdk/FlowEventResult;", "type", "", "ids", "", "getEventsForHeightRange", "range", "Lkotlin/ranges/ClosedRange;", "getLatestBlock", "sealed", "", "getLatestBlockHeader", "getLatestProtocolStateSnapshot", "Lorg/onflow/flow/sdk/FlowSnapshot;", "getNetworkParameters", "Lorg/onflow/flow/sdk/FlowChainId;", "getTransactionById", "Lorg/onflow/flow/sdk/FlowTransaction;", "getTransactionResultById", "Lorg/onflow/flow/sdk/FlowTransactionResult;", "ping", "sendTransaction", "transaction", "flow-jvm-sdk"})
@SourceDebugExtension(value={"SMAP\nFlowAccessApiImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlowAccessApiImpl.kt\norg/onflow/flow/sdk/impl/FlowAccessApiImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1549#2:254\n1620#2,3:255\n1549#2:258\n1620#2,3:259\n1549#2:262\n1620#2,3:263\n*S KotlinDebug\n*F\n+ 1 FlowAccessApiImpl.kt\norg/onflow/flow/sdk/impl/FlowAccessApiImpl\n*L\n223#1:254\n223#1:255,3\n230#1:258\n230#1:259,3\n234#1:262\n234#1:263,3\n*E\n"})
public final class FlowAccessApiImpl
implements FlowAccessApi,
Closeable {
    @NotNull
    private final AccessAPIGrpc.AccessAPIBlockingStub api;

    public FlowAccessApiImpl(@NotNull AccessAPIGrpc.AccessAPIBlockingStub api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
    }

    @Override
    public void close() {
        Channel chan = this.api.getChannel();
        if (chan instanceof ManagedChannel) {
            ((ManagedChannel)chan).shutdownNow();
        }
    }

    @Override
    public void ping() {
        this.api.ping(Access.PingRequest.newBuilder().build());
    }

    @Override
    @NotNull
    public FlowBlockHeader getLatestBlockHeader(boolean sealed) {
        Access.BlockHeaderResponse ret = this.api.getLatestBlockHeader(Access.GetLatestBlockHeaderRequest.newBuilder().setIsSealed(sealed).build());
        BlockHeaderOuterClass.BlockHeader blockHeader = ret.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)blockHeader, (String)"getBlock(...)");
        return FlowBlockHeader.Companion.of(blockHeader);
    }

    @Override
    @Nullable
    public FlowBlockHeader getBlockHeaderById(@NotNull FlowId id) {
        FlowBlockHeader flowBlockHeader;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Access.BlockHeaderResponse ret = this.api.getBlockHeaderByID(Access.GetBlockHeaderByIDRequest.newBuilder().setId(id.getByteStringValue()).build());
        if (ret.hasBlock()) {
            BlockHeaderOuterClass.BlockHeader blockHeader = ret.getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)blockHeader, (String)"getBlock(...)");
            flowBlockHeader = FlowBlockHeader.Companion.of(blockHeader);
        } else {
            flowBlockHeader = null;
        }
        return flowBlockHeader;
    }

    @Override
    @Nullable
    public FlowBlockHeader getBlockHeaderByHeight(long height) {
        FlowBlockHeader flowBlockHeader;
        Access.BlockHeaderResponse ret = this.api.getBlockHeaderByHeight(Access.GetBlockHeaderByHeightRequest.newBuilder().setHeight(height).build());
        if (ret.hasBlock()) {
            BlockHeaderOuterClass.BlockHeader blockHeader = ret.getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)blockHeader, (String)"getBlock(...)");
            flowBlockHeader = FlowBlockHeader.Companion.of(blockHeader);
        } else {
            flowBlockHeader = null;
        }
        return flowBlockHeader;
    }

    @Override
    @NotNull
    public FlowBlock getLatestBlock(boolean sealed) {
        Access.BlockResponse ret = this.api.getLatestBlock(Access.GetLatestBlockRequest.newBuilder().setIsSealed(sealed).build());
        BlockOuterClass.Block block = ret.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        return FlowBlock.Companion.of(block);
    }

    @Override
    @Nullable
    public FlowBlock getBlockById(@NotNull FlowId id) {
        FlowBlock flowBlock;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Access.BlockResponse ret = this.api.getBlockByID(Access.GetBlockByIDRequest.newBuilder().setId(id.getByteStringValue()).build());
        if (ret.hasBlock()) {
            BlockOuterClass.Block block = ret.getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            flowBlock = FlowBlock.Companion.of(block);
        } else {
            flowBlock = null;
        }
        return flowBlock;
    }

    @Override
    @Nullable
    public FlowBlock getBlockByHeight(long height) {
        FlowBlock flowBlock;
        Access.BlockResponse ret = this.api.getBlockByHeight(Access.GetBlockByHeightRequest.newBuilder().setHeight(height).build());
        if (ret.hasBlock()) {
            BlockOuterClass.Block block = ret.getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            flowBlock = FlowBlock.Companion.of(block);
        } else {
            flowBlock = null;
        }
        return flowBlock;
    }

    @Override
    @Nullable
    public FlowCollection getCollectionById(@NotNull FlowId id) {
        FlowCollection flowCollection;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Access.CollectionResponse ret = this.api.getCollectionByID(Access.GetCollectionByIDRequest.newBuilder().setId(id.getByteStringValue()).build());
        if (ret.hasCollection()) {
            CollectionOuterClass.Collection collection = ret.getCollection();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getCollection(...)");
            flowCollection = FlowCollection.Companion.of(collection);
        } else {
            flowCollection = null;
        }
        return flowCollection;
    }

    @Override
    @NotNull
    public FlowId sendTransaction(@NotNull FlowTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Access.SendTransactionResponse ret = this.api.sendTransaction(Access.SendTransactionRequest.newBuilder().setTransaction(FlowTransaction.builder$default(transaction, null, 1, null).build()).build());
        byte[] byArray = ret.getId().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return FlowId.Companion.of(byArray);
    }

    @Override
    @Nullable
    public FlowTransaction getTransactionById(@NotNull FlowId id) {
        FlowTransaction flowTransaction;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Access.TransactionResponse ret = this.api.getTransaction(Access.GetTransactionRequest.newBuilder().setId(id.getByteStringValue()).build());
        if (ret.hasTransaction()) {
            TransactionOuterClass.Transaction transaction = ret.getTransaction();
            Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"getTransaction(...)");
            flowTransaction = FlowTransaction.Companion.of(transaction);
        } else {
            flowTransaction = null;
        }
        return flowTransaction;
    }

    @Override
    @NotNull
    public FlowTransactionResult getTransactionResultById(@NotNull FlowId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Access.TransactionResultResponse ret = this.api.getTransactionResult(Access.GetTransactionRequest.newBuilder().setId(id.getByteStringValue()).build());
        Intrinsics.checkNotNull((Object)ret);
        return FlowTransactionResult.Companion.of(ret);
    }

    @Override
    @Deprecated(message="Behaves identically to getAccountAtLatestBlock", replaceWith=@ReplaceWith(expression="getAccountAtLatestBlock", imports={}))
    @Nullable
    public FlowAccount getAccountByAddress(@NotNull FlowAddress addresss) {
        FlowAccount flowAccount;
        Intrinsics.checkNotNullParameter((Object)addresss, (String)"addresss");
        Access.GetAccountResponse ret = this.api.getAccount(Access.GetAccountRequest.newBuilder().setAddress(addresss.getByteStringValue()).build());
        if (ret.hasAccount()) {
            AccountOuterClass.Account account = ret.getAccount();
            Intrinsics.checkNotNullExpressionValue((Object)account, (String)"getAccount(...)");
            flowAccount = FlowAccount.Companion.of(account);
        } else {
            flowAccount = null;
        }
        return flowAccount;
    }

    @Override
    @Nullable
    public FlowAccount getAccountAtLatestBlock(@NotNull FlowAddress addresss) {
        FlowAccount flowAccount;
        Intrinsics.checkNotNullParameter((Object)addresss, (String)"addresss");
        Access.AccountResponse ret = this.api.getAccountAtLatestBlock(Access.GetAccountAtLatestBlockRequest.newBuilder().setAddress(addresss.getByteStringValue()).build());
        if (ret.hasAccount()) {
            AccountOuterClass.Account account = ret.getAccount();
            Intrinsics.checkNotNullExpressionValue((Object)account, (String)"getAccount(...)");
            flowAccount = FlowAccount.Companion.of(account);
        } else {
            flowAccount = null;
        }
        return flowAccount;
    }

    @Override
    @Nullable
    public FlowAccount getAccountByBlockHeight(@NotNull FlowAddress addresss, long height) {
        FlowAccount flowAccount;
        Intrinsics.checkNotNullParameter((Object)addresss, (String)"addresss");
        Access.AccountResponse ret = this.api.getAccountAtBlockHeight(Access.GetAccountAtBlockHeightRequest.newBuilder().setAddress(addresss.getByteStringValue()).setBlockHeight(height).build());
        if (ret.hasAccount()) {
            AccountOuterClass.Account account = ret.getAccount();
            Intrinsics.checkNotNullExpressionValue((Object)account, (String)"getAccount(...)");
            flowAccount = FlowAccount.Companion.of(account);
        } else {
            flowAccount = null;
        }
        return flowAccount;
    }

    @Override
    @NotNull
    public FlowScriptResponse executeScriptAtLatestBlock(@NotNull FlowScript script, @NotNull Iterable<? extends ByteString> arguments) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Access.ExecuteScriptResponse ret = this.api.executeScriptAtLatestBlock(Access.ExecuteScriptAtLatestBlockRequest.newBuilder().setScript(script.getByteStringValue()).addAllArguments(arguments).build());
        byte[] byArray = ret.getValue().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return new FlowScriptResponse(byArray);
    }

    @Override
    @NotNull
    public FlowScriptResponse executeScriptAtBlockId(@NotNull FlowScript script, @NotNull FlowId blockId, @NotNull Iterable<? extends ByteString> arguments) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Access.ExecuteScriptResponse ret = this.api.executeScriptAtBlockID(Access.ExecuteScriptAtBlockIDRequest.newBuilder().setBlockId(blockId.getByteStringValue()).setScript(script.getByteStringValue()).addAllArguments(arguments).build());
        byte[] byArray = ret.getValue().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return new FlowScriptResponse(byArray);
    }

    @Override
    @NotNull
    public FlowScriptResponse executeScriptAtBlockHeight(@NotNull FlowScript script, long height, @NotNull Iterable<? extends ByteString> arguments) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Access.ExecuteScriptResponse ret = this.api.executeScriptAtBlockHeight(Access.ExecuteScriptAtBlockHeightRequest.newBuilder().setBlockHeight(height).setScript(script.getByteStringValue()).addAllArguments(arguments).build());
        byte[] byArray = ret.getValue().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return new FlowScriptResponse(byArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FlowEventResult> getEventsForHeightRange(@NotNull String type, @NotNull ClosedRange<Long> range) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        Access.EventsResponse ret = this.api.getEventsForHeightRange(Access.GetEventsForHeightRangeRequest.newBuilder().setType(type).setStartHeight(((Number)((Object)range.getStart())).longValue()).setEndHeight(((Number)((Object)range.getEndInclusive())).longValue()).build());
        List list = ret.getResultsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResultsList(...)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Access.EventsResponse.Result result = (Access.EventsResponse.Result)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(FlowEventResult.Companion.of((Access.EventsResponse.Result)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<FlowEventResult> getEventsForBlockIds(@NotNull String type, @NotNull Set<FlowId> ids) {
        Access.EventsResponse.Result it;
        Collection<ByteString> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable iterable = ids;
        Access.GetEventsForBlockIDsRequest.Builder builder = Access.GetEventsForBlockIDsRequest.newBuilder().setType(type);
        Object object = this.api;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FlowId flowId = (FlowId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getByteStringValue());
        }
        collection = (List)destination$iv$iv;
        Access.EventsResponse ret = object.getEventsForBlockIDs(builder.addAllBlockIds((Iterable)collection).build());
        List list = ret.getResultsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResultsList(...)");
        $this$map$iv = list;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Access.EventsResponse.Result)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            object.add(FlowEventResult.Companion.of(it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public FlowChainId getNetworkParameters() {
        Access.GetNetworkParametersResponse ret = this.api.getNetworkParameters(Access.GetNetworkParametersRequest.newBuilder().build());
        String string = ret.getChainId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChainId(...)");
        return FlowChainId.Companion.of(string);
    }

    @Override
    @NotNull
    public FlowSnapshot getLatestProtocolStateSnapshot() {
        Access.ProtocolStateSnapshotResponse ret = this.api.getLatestProtocolStateSnapshot(Access.GetLatestProtocolStateSnapshotRequest.newBuilder().build());
        byte[] byArray = ret.getSerializedSnapshot().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return new FlowSnapshot(byArray);
    }
}

