/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk.crypto;

import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.onflow.flow.sdk.HashAlgorithm;
import org.onflow.flow.sdk.Hasher;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/onflow/flow/sdk/crypto/HasherImpl;", "Lorg/onflow/flow/sdk/Hasher;", "hashAlgo", "Lorg/onflow/flow/sdk/HashAlgorithm;", "(Lorg/onflow/flow/sdk/HashAlgorithm;)V", "hash", "", "bytes", "flow-jvm-sdk"})
public final class HasherImpl
implements Hasher {
    @NotNull
    private final HashAlgorithm hashAlgo;

    public HasherImpl(@NotNull HashAlgorithm hashAlgo) {
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgo), (String)"hashAlgo");
        this.hashAlgo = hashAlgo;
    }

    @Override
    @NotNull
    public byte[] hash(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        MessageDigest digest = MessageDigest.getInstance(this.hashAlgo.getAlgorithm());
        byte[] byArray = digest.digest(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    @Override
    @NotNull
    public String hashAsHexString(@NotNull byte[] bytes) {
        return Hasher.DefaultImpls.hashAsHexString(this, bytes);
    }
}

