/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk;

import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.onflow.flow.sdk.FlowAccessApi;
import org.onflow.flow.sdk.FlowAddress;
import org.onflow.flow.sdk.FlowId;
import org.onflow.flow.sdk.FlowTransaction;
import org.onflow.flow.sdk.FlowTransactionResult;
import org.onflow.flow.sdk.FlowTransactionStatus;
import org.onflow.flow.sdk.FlowTransactionStub;
import org.onflow.flow.sdk.Signer;
import org.onflow.flow.sdk.TransactionBuilder;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001f\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u001a*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u001a-\u0010\u0000\u001a\u00020\u0010*\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\f2\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u001aG\u0010\u0012\u001a\u00020\u0010*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u000e2\b\b\u0002\u0010\u0018\u001a\u00020\u000e2\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0019"}, d2={"flowTransaction", "Lorg/onflow/flow/sdk/FlowTransaction;", "block", "Lkotlin/Function1;", "Lorg/onflow/flow/sdk/TransactionBuilder;", "", "Lkotlin/ExtensionFunctionType;", "waitForSeal", "Lorg/onflow/flow/sdk/FlowTransactionResult;", "api", "Lorg/onflow/flow/sdk/FlowAccessApi;", "transactionId", "Lorg/onflow/flow/sdk/FlowId;", "pauseMs", "", "timeoutMs", "Lorg/onflow/flow/sdk/FlowTransactionStub;", "referenceBlockId", "simpleFlowTransaction", "address", "Lorg/onflow/flow/sdk/FlowAddress;", "signer", "Lorg/onflow/flow/sdk/Signer;", "gasLimit", "keyIndex", "flow-jvm-sdk"})
@SourceDebugExtension(value={"SMAP\ntransaction-dsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 transaction-dsl.kt\norg/onflow/flow/sdk/Transaction_dslKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,701:1\n1#2:702\n*E\n"})
public final class Transaction_dslKt {
    @NotNull
    public static final FlowTransactionResult waitForSeal(@NotNull FlowAccessApi api, @NotNull FlowId transactionId, @NotNull Number pauseMs, @NotNull Number timeoutMs) throws TimeoutException {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        Intrinsics.checkNotNullParameter((Object)pauseMs, (String)"pauseMs");
        Intrinsics.checkNotNullParameter((Object)timeoutMs, (String)"timeoutMs");
        if (!(pauseMs.longValue() < timeoutMs.longValue())) {
            boolean bl = false;
            String string = "pause must be less than timeout";
            throw new IllegalStateException(string.toString());
        }
        long start = System.currentTimeMillis();
        FlowTransactionResult ret = null;
        do {
            if (api.getTransactionResultById(transactionId) == null) {
                boolean bl = false;
                String string = "Transaction with that id not found";
                throw new IllegalStateException(string.toString());
            }
            if (ret.getStatus() == FlowTransactionStatus.SEALED) {
                return ret;
            }
            Thread.sleep(pauseMs.longValue());
        } while (System.currentTimeMillis() - start <= timeoutMs.longValue());
        throw new TimeoutException("Timeout waiting for seal");
    }

    public static /* synthetic */ FlowTransactionResult waitForSeal$default(FlowAccessApi flowAccessApi, FlowId flowId, Number number, Number number2, int n, Object object) throws TimeoutException {
        if ((n & 4) != 0) {
            number = 500L;
        }
        if ((n & 8) != 0) {
            number2 = 10000L;
        }
        return Transaction_dslKt.waitForSeal(flowAccessApi, flowId, number, number2);
    }

    @NotNull
    public static final FlowTransaction flowTransaction(@NotNull Function1<? super TransactionBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        TransactionBuilder builder = new TransactionBuilder(null, 1, null);
        block.invoke((Object)builder);
        return builder.build();
    }

    @NotNull
    public static final FlowTransactionStub flowTransaction(@NotNull FlowAccessApi $this$flowTransaction, @NotNull FlowId referenceBlockId, @NotNull Function1<? super TransactionBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$flowTransaction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)referenceBlockId, (String)"referenceBlockId");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        TransactionBuilder builder = new TransactionBuilder($this$flowTransaction);
        builder.setReferenceBlockId(referenceBlockId);
        block.invoke((Object)builder);
        return new FlowTransactionStub($this$flowTransaction, builder);
    }

    public static /* synthetic */ FlowTransactionStub flowTransaction$default(FlowAccessApi flowAccessApi, FlowId flowId, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            flowId = FlowAccessApi.DefaultImpls.getLatestBlockHeader$default(flowAccessApi, false, 1, null).getId();
        }
        return Transaction_dslKt.flowTransaction(flowAccessApi, flowId, (Function1<? super TransactionBuilder, Unit>)function1);
    }

    @NotNull
    public static final FlowTransactionStub simpleFlowTransaction(@NotNull FlowAccessApi $this$simpleFlowTransaction, @NotNull FlowAddress address, @NotNull Signer signer, @NotNull Number gasLimit, @NotNull Number keyIndex, @NotNull Function1<? super TransactionBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$simpleFlowTransaction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        Intrinsics.checkNotNullParameter((Object)gasLimit, (String)"gasLimit");
        Intrinsics.checkNotNullParameter((Object)keyIndex, (String)"keyIndex");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return Transaction_dslKt.flowTransaction$default($this$simpleFlowTransaction, null, (Function1)new Function1<TransactionBuilder, Unit>(gasLimit, address, keyIndex, signer, block){
            final /* synthetic */ Number $gasLimit;
            final /* synthetic */ FlowAddress $address;
            final /* synthetic */ Number $keyIndex;
            final /* synthetic */ Signer $signer;
            final /* synthetic */ Function1<TransactionBuilder, Unit> $block;
            {
                this.$gasLimit = $gasLimit;
                this.$address = $address;
                this.$keyIndex = $keyIndex;
                this.$signer = $signer;
                this.$block = $block;
                super(1);
            }

            public final void invoke(@NotNull TransactionBuilder $this$flowTransaction) {
                Intrinsics.checkNotNullParameter((Object)$this$flowTransaction, (String)"$this$flowTransaction");
                $this$flowTransaction.gasLimit(this.$gasLimit);
                $this$flowTransaction.proposeAndPay(this.$address, this.$keyIndex, this.$signer);
                this.$block.invoke((Object)$this$flowTransaction);
            }
        }, 1, null);
    }

    public static /* synthetic */ FlowTransactionStub simpleFlowTransaction$default(FlowAccessApi flowAccessApi, FlowAddress flowAddress, Signer signer, Number number, Number number2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            number = 100;
        }
        if ((n & 8) != 0) {
            number2 = 0;
        }
        return Transaction_dslKt.simpleFlowTransaction(flowAccessApi, flowAddress, signer, number, number2, (Function1<? super TransactionBuilder, Unit>)function1);
    }
}

