/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.exceptions.CsvEntityException;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;

public class FareAmountFieldMappingFactory
implements FieldMappingFactory {
    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        return new FareAmountFieldMapping(entityType, csvFieldName, objFieldName, required);
    }

    private static class FareAmountFieldMapping
    extends AbstractFieldMapping {
        public FareAmountFieldMapping(Class<?> entityType, String csvFieldName, String objFieldName, boolean required) {
            super(entityType, csvFieldName, objFieldName, required);
        }

        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            String currencyString = (String)object.getPropertyValue("currency");
            Currency currency = Currency.getInstance(currencyString);
            Float amount = (Float)object.getPropertyValue(this._objFieldName);
            DecimalFormat formatter = (DecimalFormat)NumberFormat.getCurrencyInstance(Locale.US);
            formatter.setCurrency(currency);
            DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
            symbols.setCurrencySymbol("");
            formatter.setDecimalFormatSymbols(symbols);
            formatter.setMaximumFractionDigits(currency.getDefaultFractionDigits());
            csvValues.put(this._csvFieldName, formatter.format(amount));
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) throws CsvEntityException {
            if (this.isMissingAndOptional(csvValues)) {
                return;
            }
            Object value = csvValues.get(this._csvFieldName);
            Float amount = Float.valueOf(Float.parseFloat(value.toString()));
            object.setPropertyValue(this._objFieldName, (Object)amount);
        }
    }
}

