/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.InvalidStopTimeException;

public class StopTimeFieldMappingFactory
implements FieldMappingFactory {
    private static DecimalFormat _format = new DecimalFormat("00", new DecimalFormatSymbols(Locale.ENGLISH));
    private static Pattern _pattern = Pattern.compile("^(-{0,1}\\d+):(\\d{2}):(\\d{2})$");

    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        return new StopTimeFieldMapping(entityType, csvFieldName, objFieldName, required);
    }

    public static String getSecondsAsString(int t) {
        int seconds = StopTimeFieldMappingFactory.positiveMod(t, 60);
        int hourAndMinutes = (t - seconds) / 60;
        int minutes = StopTimeFieldMappingFactory.positiveMod(hourAndMinutes, 60);
        int hours = (hourAndMinutes - minutes) / 60;
        StringBuilder b = new StringBuilder();
        b.append(_format.format(hours));
        b.append(":");
        b.append(_format.format(minutes));
        b.append(":");
        b.append(_format.format(seconds));
        return b.toString();
    }

    private static final int positiveMod(int value, int modulo) {
        int m = value % modulo;
        if (m < 0) {
            m += modulo;
        }
        return m;
    }

    public static int getStringAsSeconds(String value) {
        Matcher m = _pattern.matcher(value);
        if (!m.matches()) {
            throw new InvalidStopTimeException(value);
        }
        try {
            int hours = Integer.parseInt(m.group(1));
            int minutes = Integer.parseInt(m.group(2));
            int seconds = Integer.parseInt(m.group(3));
            return seconds + 60 * (minutes + 60 * hours);
        }
        catch (NumberFormatException ex) {
            throw new InvalidStopTimeException(value);
        }
    }

    private static class StopTimeFieldMapping
    extends AbstractFieldMapping
    implements Converter {
        public StopTimeFieldMapping(Class<?> entityType, String csvFieldName, String objFieldName, boolean required) {
            super(entityType, csvFieldName, objFieldName, required);
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            if (this.isMissingAndOptional(csvValues)) {
                return;
            }
            Object value = csvValues.get(this._csvFieldName);
            object.setPropertyValue(this._objFieldName, this.convert(Integer.TYPE, value));
        }

        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            int t = (Integer)object.getPropertyValue(this._objFieldName);
            if (t < 0) {
                csvValues.put(this._csvFieldName, "");
                return;
            }
            String value = StopTimeFieldMappingFactory.getSecondsAsString(t);
            csvValues.put(this._csvFieldName, value);
        }

        public Object convert(Class type, Object value) {
            if (type == Integer.class || type == Integer.TYPE) {
                String stringValue = value.toString();
                return StopTimeFieldMappingFactory.getStringAsSeconds(stringValue);
            }
            if (type == String.class) {
                return StopTimeFieldMappingFactory.getSecondsAsString((Integer)value);
            }
            throw new ConversionException("Could not convert " + String.valueOf(value) + " of type " + String.valueOf(value.getClass()) + " to " + String.valueOf(type));
        }
    }
}

