/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.util.Collection;
import java.util.Map;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.exceptions.MissingRequiredFieldException;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.DefaultFieldMapping;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;
import org.onebusaway.gtfs.model.AgencyAndId;

public class AgencyIdFieldMappingFactory
implements FieldMappingFactory {
    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        return new FieldMappingImpl(entityType, csvFieldName, objFieldName, String.class, required);
    }

    private class FieldMappingImpl
    extends DefaultFieldMapping {
        public FieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
            super(entityType, csvFieldName, objFieldName, objFieldType, required);
        }

        public void getCSVFieldNames(Collection<String> names) {
            names.add(this._csvFieldName + "_agencyId");
            names.add(this._csvFieldName + "_id");
        }

        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            AgencyAndId id = (AgencyAndId)object.getPropertyValue(this._objFieldName);
            csvValues.put(this._csvFieldName + "_agencyId", id.getAgencyId());
            csvValues.put(this._csvFieldName + "_id", id.getId());
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            boolean missing;
            String agencyId = (String)csvValues.get(this._csvFieldName + "_agencyId");
            String id = (String)csvValues.get(this._csvFieldName + "_id");
            boolean bl = missing = agencyId == null || agencyId.isEmpty() || id == null || id.isEmpty();
            if (missing) {
                if (this._required) {
                    throw new MissingRequiredFieldException(this._entityType, this._csvFieldName);
                }
                return;
            }
            AgencyAndId agencyAndId = new AgencyAndId(agencyId, id);
            object.setPropertyValue(this._objFieldName, (Object)agencyAndId);
        }
    }
}

