/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model;

import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.Area;
import org.onebusaway.gtfs.model.BookingRule;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Note;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTimeProxy;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.serialization.mappings.EntityFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.StopLocationFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.StopTimeFieldMappingFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CsvFields(filename="stop_times.txt")
public final class StopTime
extends IdentityBean<Integer>
implements Comparable<StopTime>,
StopTimeProxy {
    private static Logger _log = LoggerFactory.getLogger(StopTime.class);
    private static final long serialVersionUID = 2L;
    public static final int MISSING_VALUE = -999;
    public static final int MISSING_FLEX_VALUE = 1;
    @CsvField(ignore=true)
    private int id;
    @CsvField(name="trip_id", mapping=EntityFieldMappingFactory.class)
    private Trip trip;
    @CsvField(name="stop_id", optional=true, mapping=StopLocationFieldMappingFactory.class)
    private StopLocation stop;
    @CsvField(name="location_id", optional=true, mapping=StopLocationFieldMappingFactory.class)
    private StopLocation location;
    @CsvField(name="location_group_id", optional=true, mapping=StopLocationFieldMappingFactory.class)
    private StopLocation locationGroup;
    @CsvField(optional=true, mapping=StopTimeFieldMappingFactory.class)
    private int arrivalTime = -999;
    @CsvField(optional=true, mapping=StopTimeFieldMappingFactory.class)
    private int departureTime = -999;
    @CsvField(optional=true, name="start_pickup_drop_off_window", mapping=StopTimeFieldMappingFactory.class, defaultValue="-999")
    private int startPickupDropOffWindow = -999;
    @CsvField(optional=true, name="end_pickup_drop_off_window", mapping=StopTimeFieldMappingFactory.class, defaultValue="-999")
    private int endPickupDropOffWindow = -999;
    @CsvField(optional=true, defaultValue="-999")
    private int timepoint = -999;
    private int stopSequence;
    @CsvField(optional=true)
    private Integer toStopSequence;
    @CsvField(optional=true)
    private String stopHeadsign;
    @CsvField(optional=true)
    private String routeShortName;
    @CsvField(optional=true, defaultValue="0")
    private int pickupType;
    @CsvField(optional=true, defaultValue="0")
    private int dropOffType;
    @CsvField(optional=true, defaultValue="-999")
    private double shapeDistTraveled = -999.0;
    @CsvField(optional=true, defaultValue="1")
    private int continuousPickup = 1;
    @CsvField(optional=true, defaultValue="1")
    private int continuousDropOff = 1;
    @CsvField(optional=true, name="start_service_area_id", mapping=EntityFieldMappingFactory.class, order=-2)
    private Area startServiceArea;
    @CsvField(optional=true, name="end_service_area_id", mapping=EntityFieldMappingFactory.class, order=-2)
    private Area endServiceArea;
    @CsvField(optional=true, defaultValue="-999.0")
    private double startServiceAreaRadius = -999.0;
    @CsvField(optional=true, defaultValue="-999.0")
    private double endServiceAreaRadius = -999.0;
    @CsvField(ignore=true)
    private transient StopTimeProxy proxy = null;
    @CsvField(optional=true, name="pickup_booking_rule_id", mapping=EntityFieldMappingFactory.class, order=-2)
    private BookingRule pickupBookingRule;
    @CsvField(optional=true, name="drop_off_booking_rule_id", mapping=EntityFieldMappingFactory.class, order=-2)
    private BookingRule dropOffBookingRule;
    @CsvField(optional=true)
    private String farePeriodId;
    @CsvField(optional=true, defaultValue="-999")
    private int departureBuffer;
    @CsvField(optional=true)
    private String track;
    @CsvField(optional=true, name="note_id", mapping=EntityFieldMappingFactory.class, order=-1)
    private Note note;
    @CsvField(optional=true, name="mean_duration_factor", defaultValue="-999.0")
    private double meanDurationFactor = -999.0;
    @CsvField(optional=true, name="mean_duration_offset", defaultValue="-999.0")
    private double meanDurationOffset = -999.0;
    @CsvField(optional=true, name="safe_duration_factor", defaultValue="-999.0")
    private double safeDurationFactor = -999.0;
    @CsvField(optional=true, name="safe_duration_offset", defaultValue="-999.0")
    private double safeDurationOffset = -999.0;
    @CsvField(optional=true, name="free_running_flag")
    private String freeRunningFlag;

    public StopTime() {
    }

    public StopTime(StopTime st) {
        this.arrivalTime = st.arrivalTime;
        this.departureTime = st.departureTime;
        this.dropOffType = st.dropOffType;
        this.id = st.id;
        this.pickupType = st.pickupType;
        this.startPickupDropOffWindow = st.startPickupDropOffWindow;
        this.endPickupDropOffWindow = st.endPickupDropOffWindow;
        this.continuousPickup = st.continuousPickup;
        this.continuousDropOff = st.continuousDropOff;
        this.routeShortName = st.routeShortName;
        this.shapeDistTraveled = st.shapeDistTraveled;
        this.farePeriodId = st.farePeriodId;
        this.stop = st.stop;
        this.location = st.location;
        this.locationGroup = st.locationGroup;
        this.stopHeadsign = st.stopHeadsign;
        this.stopSequence = st.stopSequence;
        this.toStopSequence = st.toStopSequence;
        this.timepoint = st.timepoint;
        this.trip = st.trip;
        this.startServiceArea = st.startServiceArea;
        this.endServiceArea = st.endServiceArea;
        this.startServiceAreaRadius = st.startServiceAreaRadius;
        this.endServiceAreaRadius = st.endServiceAreaRadius;
        this.departureBuffer = st.departureBuffer;
        this.track = st.track;
        this.note = st.note;
        this.pickupBookingRule = st.pickupBookingRule;
        this.dropOffBookingRule = st.dropOffBookingRule;
        this.safeDurationFactor = st.safeDurationFactor;
        this.safeDurationOffset = st.safeDurationOffset;
        this.meanDurationOffset = st.meanDurationOffset;
        this.meanDurationFactor = st.meanDurationFactor;
        this.freeRunningFlag = st.freeRunningFlag;
    }

    @Override
    public Integer getId() {
        if (this.proxy != null) {
            return this.proxy.getId();
        }
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        if (this.proxy != null) {
            this.proxy.setId(id);
            return;
        }
        this.id = id;
    }

    @Override
    public Trip getTrip() {
        if (this.proxy != null) {
            return this.proxy.getTrip();
        }
        return this.trip;
    }

    @Override
    public void setTrip(Trip trip) {
        if (this.proxy != null) {
            this.proxy.setTrip(trip);
            return;
        }
        this.trip = trip;
    }

    @Override
    public int getStopSequence() {
        if (this.proxy != null) {
            return this.proxy.getStopSequence();
        }
        return this.stopSequence;
    }

    @Override
    public void setStopSequence(int stopSequence) {
        if (this.proxy != null) {
            this.proxy.setStopSequence(stopSequence);
            return;
        }
        this.stopSequence = stopSequence;
    }

    public Integer getToStopSequence() {
        return this.toStopSequence;
    }

    public void setToStopSequence(Integer toStopSequence) {
        this.toStopSequence = toStopSequence;
    }

    @Override
    public StopLocation getStop() {
        if (this.proxy != null) {
            return this.proxy.getStop();
        }
        return this.stop;
    }

    @Override
    public StopLocation getLocation() {
        if (this.proxy != null) {
            return this.proxy.getLocation();
        }
        return this.location;
    }

    @Override
    public StopLocation getLocationGroup() {
        if (this.proxy != null) {
            return this.proxy.getLocationGroup();
        }
        return this.locationGroup;
    }

    public StopLocation getStopLocation() {
        if (this.getStop() != null) {
            return this.getStop();
        }
        if (this.getLocation() != null) {
            return this.getLocation();
        }
        if (this.getLocationGroup() != null) {
            return this.getLocationGroup();
        }
        return null;
    }

    @Override
    public void setStop(StopLocation stop) {
        if (this.proxy != null) {
            this.proxy.setStop(stop);
            return;
        }
        this.stop = stop;
    }

    @Override
    public void setLocation(StopLocation location) {
        if (this.proxy != null) {
            this.proxy.setLocation(location);
            return;
        }
        this.location = location;
    }

    @Override
    public void setLocationGroup(StopLocation group) {
        if (this.proxy != null) {
            this.proxy.setLocationGroup(group);
            return;
        }
        this.locationGroup = group;
    }

    @Override
    public boolean isArrivalTimeSet() {
        if (this.proxy != null) {
            return this.proxy.isArrivalTimeSet();
        }
        return this.arrivalTime != -999;
    }

    @Override
    public int getArrivalTime() {
        if (this.proxy != null) {
            return this.proxy.getArrivalTime();
        }
        return this.arrivalTime;
    }

    @Override
    public void setArrivalTime(int arrivalTime) {
        if (this.proxy != null) {
            this.proxy.setArrivalTime(arrivalTime);
            return;
        }
        this.arrivalTime = arrivalTime;
    }

    @Override
    public void clearArrivalTime() {
        if (this.proxy != null) {
            this.proxy.clearArrivalTime();
            return;
        }
        this.arrivalTime = -999;
    }

    @Override
    public boolean isDepartureTimeSet() {
        if (this.proxy != null) {
            return this.proxy.isDepartureTimeSet();
        }
        return this.departureTime != -999;
    }

    @Override
    public int getDepartureTime() {
        if (this.proxy != null) {
            return this.proxy.getDepartureTime();
        }
        return this.departureTime;
    }

    @Override
    public void setDepartureTime(int departureTime) {
        if (this.proxy != null) {
            this.proxy.setDepartureTime(departureTime);
            return;
        }
        this.departureTime = departureTime;
    }

    @Override
    public void clearDepartureTime() {
        if (this.proxy != null) {
            this.proxy.clearDepartureTime();
            return;
        }
        this.departureTime = -999;
    }

    public int getStartPickupDropOffWindow() {
        return this.startPickupDropOffWindow;
    }

    public void setStartPickupDropOffWindow(int startPickupDropOffWindow) {
        this.startPickupDropOffWindow = startPickupDropOffWindow;
    }

    public int getEndPickupDropOffWindow() {
        return this.endPickupDropOffWindow;
    }

    public void setEndPickupDropOffWindow(int endPickupDropOffWindow) {
        this.endPickupDropOffWindow = endPickupDropOffWindow;
    }

    @Override
    public boolean isTimepointSet() {
        if (this.proxy != null) {
            return this.proxy.isTimepointSet();
        }
        return this.timepoint != -999;
    }

    @Override
    public int getTimepoint() {
        if (this.proxy != null) {
            return this.proxy.getTimepoint();
        }
        return this.timepoint;
    }

    @Override
    public void setTimepoint(int timepoint) {
        if (this.proxy != null) {
            this.proxy.setTimepoint(timepoint);
            return;
        }
        this.timepoint = timepoint;
    }

    @Override
    public void clearTimepoint() {
        if (this.proxy != null) {
            this.proxy.clearTimepoint();
            return;
        }
        this.timepoint = -999;
    }

    @Override
    public String getStopHeadsign() {
        if (this.proxy != null) {
            return this.proxy.getStopHeadsign();
        }
        return this.stopHeadsign;
    }

    @Override
    public void setStopHeadsign(String headSign) {
        if (this.proxy != null) {
            this.proxy.setStopHeadsign(headSign);
            return;
        }
        this.stopHeadsign = headSign;
    }

    @Override
    public String getRouteShortName() {
        if (this.proxy != null) {
            return this.proxy.getRouteShortName();
        }
        return this.routeShortName;
    }

    @Override
    public void setRouteShortName(String routeShortName) {
        if (this.proxy != null) {
            this.proxy.setRouteShortName(routeShortName);
            return;
        }
        this.routeShortName = routeShortName;
    }

    @Override
    public int getPickupType() {
        if (this.proxy != null) {
            return this.proxy.getPickupType();
        }
        return this.pickupType;
    }

    @Override
    public void setPickupType(int pickupType) {
        if (this.proxy != null) {
            this.proxy.setPickupType(pickupType);
        }
        this.pickupType = pickupType;
    }

    @Override
    public int getDropOffType() {
        if (this.proxy != null) {
            return this.proxy.getDropOffType();
        }
        return this.dropOffType;
    }

    @Override
    public void setDropOffType(int dropOffType) {
        if (this.proxy != null) {
            this.proxy.setDropOffType(dropOffType);
            return;
        }
        this.dropOffType = dropOffType;
    }

    public int getContinuousPickup() {
        return this.continuousPickup;
    }

    public void setContinuousPickup(int continuousPickup) {
        this.continuousPickup = continuousPickup;
    }

    public int getContinuousDropOff() {
        return this.continuousDropOff;
    }

    public void setContinuousDropOff(int continuousDropOff) {
        this.continuousDropOff = continuousDropOff;
    }

    @Override
    public boolean isShapeDistTraveledSet() {
        if (this.proxy != null) {
            return this.proxy.isShapeDistTraveledSet();
        }
        return this.shapeDistTraveled != -999.0;
    }

    @Override
    public double getShapeDistTraveled() {
        if (this.proxy != null) {
            return this.proxy.getShapeDistTraveled();
        }
        return this.shapeDistTraveled;
    }

    @Override
    public void setShapeDistTraveled(double shapeDistTraveled) {
        if (this.proxy != null) {
            this.proxy.setShapeDistTraveled(shapeDistTraveled);
            return;
        }
        this.shapeDistTraveled = shapeDistTraveled;
    }

    @Override
    public void clearShapeDistTraveled() {
        if (this.proxy != null) {
            this.proxy.clearShapeDistTraveled();
            return;
        }
        this.shapeDistTraveled = -999.0;
    }

    public String getFarePeriodId() {
        return this.farePeriodId;
    }

    public void setFarePeriodId(String farePeriodId) {
        this.farePeriodId = farePeriodId;
    }

    @Override
    public Area getStartServiceArea() {
        if (this.proxy != null) {
            return this.proxy.getStartServiceArea();
        }
        return this.startServiceArea;
    }

    @Override
    public void setStartServiceArea(Area startServiceArea) {
        if (this.proxy != null) {
            this.proxy.setStartServiceArea(startServiceArea);
            return;
        }
        this.startServiceArea = startServiceArea;
    }

    @Override
    public Area getEndServiceArea() {
        if (this.proxy != null) {
            return this.proxy.getEndServiceArea();
        }
        return this.endServiceArea;
    }

    @Override
    public void setEndServiceArea(Area endServiceArea) {
        if (this.proxy != null) {
            this.proxy.setEndServiceArea(endServiceArea);
            return;
        }
        this.endServiceArea = endServiceArea;
    }

    public double getStartServiceAreaRadius() {
        return this.startServiceAreaRadius;
    }

    public void setStartServiceAreaRadius(double startServiceAreaRadius) {
        this.startServiceAreaRadius = startServiceAreaRadius;
    }

    public double getEndServiceAreaRadius() {
        return this.endServiceAreaRadius;
    }

    public void setEndServiceAreaRadius(double endServiceAreaRadius) {
        this.endServiceAreaRadius = endServiceAreaRadius;
    }

    public int getDepartureBuffer() {
        return this.departureBuffer;
    }

    public void setDepartureBuffer(int departureBuffer) {
        this.departureBuffer = departureBuffer;
    }

    public String getTrack() {
        return this.track;
    }

    public void setTrack(String track) {
        this.track = track;
    }

    public Note getNote() {
        return this.note;
    }

    public void setNote(Note note) {
        this.note = note;
    }

    @Override
    public int compareTo(StopTime o) {
        return this.getStopSequence() - o.getStopSequence();
    }

    @Override
    public BookingRule getPickupBookingRule() {
        if (this.proxy != null) {
            return this.proxy.getPickupBookingRule();
        }
        return this.pickupBookingRule;
    }

    @Override
    public void setPickupBookingRule(BookingRule pickupBookingRule) {
        if (this.proxy != null) {
            this.proxy.setPickupBookingRule(pickupBookingRule);
            return;
        }
        this.pickupBookingRule = pickupBookingRule;
    }

    @Override
    public BookingRule getDropOffBookingRule() {
        if (this.proxy != null) {
            return this.proxy.getDropOffBookingRule();
        }
        return this.dropOffBookingRule;
    }

    @Override
    public void setDropOffBookingRule(BookingRule dropOffBookingRule) {
        if (this.proxy != null) {
            this.proxy.setDropOffBookingRule(dropOffBookingRule);
            return;
        }
        this.dropOffBookingRule = dropOffBookingRule;
    }

    public void setProxy(StopTimeProxy proxy) {
        this.proxy = proxy;
    }

    public StopTimeProxy getProxy() {
        return this.proxy;
    }

    public String displayArrival() {
        return "StopTime(Arrival time=" + StopTimeFieldMappingFactory.getSecondsAsString(this.getArrivalTime()) + ")";
    }

    public String toString() {
        return "StopTime(seq=" + this.getStopSequence() + " stop=" + String.valueOf(this.getStopLocation() == null ? "NuLl" : this.getStopLocation().getId()) + " trip=" + String.valueOf(this.getTrip() == null ? "NuLl" : this.getTrip().getId()) + " times=" + StopTimeFieldMappingFactory.getSecondsAsString(this.getArrivalTime()) + "-" + StopTimeFieldMappingFactory.getSecondsAsString(this.getDepartureTime()) + ")";
    }

    @Override
    public double getMeanDurationFactor() {
        return this.meanDurationFactor;
    }

    @Override
    public void setMeanDurationFactor(double meanDurationFactor) {
        this.meanDurationFactor = meanDurationFactor;
    }

    @Override
    public double getMeanDurationOffset() {
        return this.meanDurationOffset;
    }

    @Override
    public void setMeanDurationOffset(double meanDurationOffset) {
        this.meanDurationOffset = meanDurationOffset;
    }

    @Override
    public double getSafeDurationFactor() {
        if (this.proxy != null) {
            return this.proxy.getSafeDurationFactor();
        }
        return this.safeDurationFactor;
    }

    @Override
    public void setSafeDurationFactor(double safeDurationFactor) {
        if (this.proxy != null) {
            this.proxy.setSafeDurationFactor(safeDurationFactor);
            return;
        }
        this.safeDurationFactor = safeDurationFactor;
    }

    @Override
    public double getSafeDurationOffset() {
        if (this.proxy != null) {
            return this.proxy.getSafeDurationOffset();
        }
        return this.safeDurationOffset;
    }

    @Override
    public void setSafeDurationOffset(double safeDurationOffset) {
        if (this.proxy != null) {
            this.proxy.setSafeDurationOffset(safeDurationOffset);
            return;
        }
        this.safeDurationOffset = safeDurationOffset;
    }

    @Override
    public String getFreeRunningFlag() {
        if (this.proxy != null) {
            return this.proxy.getFreeRunningFlag();
        }
        return this.freeRunningFlag;
    }

    @Override
    public void setFreeRunningFlag(String freeRunningFlag) {
        if (this.proxy != null) {
            this.proxy.setFreeRunningFlag(freeRunningFlag);
            return;
        }
        this.freeRunningFlag = freeRunningFlag;
    }
}

