/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Location;
import org.onebusaway.gtfs.model.LocationGroup;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;
import org.onebusaway.gtfs.serialization.mappings.EntityFieldMappingImpl;

public class StopLocationFieldMappingImpl
extends EntityFieldMappingImpl {
    public StopLocationFieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        super(entityType, csvFieldName, objFieldName, objFieldType, required);
    }

    @Override
    public Converter create(CsvEntityContext context) {
        GtfsReaderContext ctx = (GtfsReaderContext)context.get((Object)GtfsReader.KEY_CONTEXT);
        return new ConverterImpl(this, ctx);
    }

    private class ConverterImpl
    implements Converter {
        private final GtfsReaderContext _context;

        public ConverterImpl(StopLocationFieldMappingImpl stopLocationFieldMappingImpl, GtfsReaderContext context) {
            this._context = context;
        }

        public Object convert(Class type, Object value) {
            if (type == String.class) {
                if (value instanceof String) {
                    return value;
                }
                return null;
            }
            if (type == StopLocation.class) {
                String entityId = value.toString();
                String agencyId = this._context.getDefaultAgencyId();
                AgencyAndId id = new AgencyAndId(agencyId, entityId);
                Object stop = this._context.getEntity(Stop.class, id);
                if (stop != null) {
                    return stop;
                }
                Object location = this._context.getEntity(Location.class, id);
                if (location != null) {
                    return location;
                }
                Object locationGroup = this._context.getEntity(LocationGroup.class, id);
                if (locationGroup != null) {
                    return locationGroup;
                }
                return null;
            }
            throw new ConversionException("Could not convert %s of type %s to %s".formatted(value, value.getClass(), type));
        }
    }
}

