/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.exceptions.MissingRequiredFieldException;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.BeanWrapperFactory;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;

public class InternAgencyIdFieldMappingFactory
implements FieldMappingFactory {
    private String _agencyIdPath = null;

    public InternAgencyIdFieldMappingFactory() {
        this(null);
    }

    public InternAgencyIdFieldMappingFactory(String agencyIdPath) {
        this._agencyIdPath = agencyIdPath;
    }

    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        if (this._agencyIdPath == null) {
            if (required) {
                return new RequiredFieldMappingImpl(entityType, csvFieldName, objFieldName);
            }
            return new OptionalFieldMappingImpl(entityType, csvFieldName, objFieldName);
        }
        if (required) {
            return new RequiredPathFieldMappingImpl(entityType, csvFieldName, objFieldName, this._agencyIdPath);
        }
        return new OptionalPathFieldMappingImpl(entityType, csvFieldName, objFieldName, this._agencyIdPath);
    }

    private static class RequiredFieldMappingImpl
    extends AbstractAgencyFieldMappingImpl {
        public RequiredFieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName) {
            super(entityType, csvFieldName, objFieldName, true);
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            String id = (String)csvValues.get(this._csvFieldName);
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new MissingRequiredFieldException(this._entityType, this._csvFieldName);
            }
            GtfsReaderContext ctx = (GtfsReaderContext)context.get((Object)GtfsReader.KEY_CONTEXT);
            String agencyId = ctx.getDefaultAgencyId();
            this.setAgencyId(object, id, agencyId);
        }
    }

    private static class OptionalFieldMappingImpl
    extends AbstractAgencyFieldMappingImpl {
        public OptionalFieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName) {
            super(entityType, csvFieldName, objFieldName, false);
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            String id = (String)csvValues.get(this._csvFieldName);
            if (StringUtils.isBlank((CharSequence)id)) {
                return;
            }
            GtfsReaderContext ctx = (GtfsReaderContext)context.get((Object)GtfsReader.KEY_CONTEXT);
            String agencyId = ctx.getDefaultAgencyId();
            this.setAgencyId(object, id, agencyId);
        }
    }

    private static class RequiredPathFieldMappingImpl
    extends AbstractAgencyFieldMappingImpl {
        private final String[] _agencyIdPathProperties;

        public RequiredPathFieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, String path) {
            super(entityType, csvFieldName, objFieldName, true);
            this._agencyIdPathProperties = path.split(".");
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            String id = (String)csvValues.get(this._csvFieldName);
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new MissingRequiredFieldException(this._entityType, this._csvFieldName);
            }
            String agencyId = this.resolveAgencyId(object);
            this.setAgencyId(object, id, agencyId);
        }

        private String resolveAgencyId(BeanWrapper object) {
            for (String property : this._agencyIdPathProperties) {
                Object value = object.getPropertyValue(property);
                object = BeanWrapperFactory.wrap((Object)value);
            }
            return object.getWrappedInstance(Object.class).toString();
        }
    }

    private static class OptionalPathFieldMappingImpl
    extends AbstractAgencyFieldMappingImpl {
        private final String[] _agencyIdPathProperties;

        public OptionalPathFieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, String path) {
            super(entityType, csvFieldName, objFieldName, false);
            this._agencyIdPathProperties = path.split(".");
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            String id = (String)csvValues.get(this._csvFieldName);
            if (StringUtils.isBlank((CharSequence)id)) {
                return;
            }
            String agencyId = this.resolveAgencyId(object);
            this.setAgencyId(object, id, agencyId);
        }

        private String resolveAgencyId(BeanWrapper object) {
            for (String property : this._agencyIdPathProperties) {
                Object value = object.getPropertyValue(property);
                object = BeanWrapperFactory.wrap((Object)value);
            }
            return object.getWrappedInstance(Object.class).toString();
        }
    }

    private static abstract class AbstractAgencyFieldMappingImpl
    extends AbstractFieldMapping {
        private Map<AgencyAndId, AgencyAndId> intern = new HashMap<AgencyAndId, AgencyAndId>(1024);
        private AgencyAndId previousAgencyAndId;

        public AbstractAgencyFieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, boolean required) {
            super(entityType, csvFieldName, objFieldName, required);
        }

        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            if (this.isMissingAndOptional(object)) {
                return;
            }
            AgencyAndId id = (AgencyAndId)object.getPropertyValue(this._objFieldName);
            csvValues.put(this._csvFieldName, id.getId());
        }

        protected void setAgencyId(BeanWrapper object, String id, String agencyId) {
            AgencyAndId agencyAndId = this.previousAgencyAndId;
            if (agencyAndId == null || !Objects.equals(id, agencyAndId.getId()) || agencyId != agencyAndId.getAgencyId()) {
                agencyAndId = new AgencyAndId(agencyId, id);
                this.previousAgencyAndId = agencyAndId = this.intern(agencyAndId);
            }
            object.setPropertyValue(this._objFieldName, (Object)agencyAndId);
        }

        protected AgencyAndId intern(AgencyAndId agencyAndId) {
            AgencyAndId interned = this.intern.get(agencyAndId);
            if (interned != null) {
                return interned;
            }
            this.intern.put(agencyAndId, agencyAndId);
            return agencyAndId;
        }
    }
}

