/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.exceptions.MissingRequiredFieldException;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.BeanWrapperFactory;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;

public class DefaultAgencyIdFieldMappingFactory
implements FieldMappingFactory {
    private String _agencyIdPath = null;

    public DefaultAgencyIdFieldMappingFactory() {
        this(null);
    }

    public DefaultAgencyIdFieldMappingFactory(String agencyIdPath) {
        this._agencyIdPath = agencyIdPath;
    }

    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        if (this._agencyIdPath == null) {
            if (required) {
                return new RequiredFieldMappingImpl(entityType, csvFieldName, objFieldName);
            }
            return new OptionalFieldMappingImpl(entityType, csvFieldName, objFieldName);
        }
        if (required) {
            return new RequiredPathFieldMappingImpl(entityType, csvFieldName, objFieldName, this._agencyIdPath);
        }
        return new OptionalPathFieldMappingImpl(entityType, csvFieldName, objFieldName, this._agencyIdPath);
    }

    private static class RequiredFieldMappingImpl
    extends AbstractAgencyFieldMappingImpl {
        public RequiredFieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName) {
            super(entityType, csvFieldName, objFieldName, true);
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            String id = (String)csvValues.get(this._csvFieldName);
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new MissingRequiredFieldException(this._entityType, this._csvFieldName);
            }
            GtfsReaderContext ctx = (GtfsReaderContext)context.get((Object)GtfsReader.KEY_CONTEXT);
            object.setPropertyValue(this._objFieldName, (Object)new AgencyAndId(ctx.getDefaultAgencyId(), id));
        }
    }

    private static class OptionalFieldMappingImpl
    extends AbstractAgencyFieldMappingImpl {
        public OptionalFieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName) {
            super(entityType, csvFieldName, objFieldName, false);
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            String id = (String)csvValues.get(this._csvFieldName);
            if (StringUtils.isBlank((CharSequence)id)) {
                return;
            }
            GtfsReaderContext ctx = (GtfsReaderContext)context.get((Object)GtfsReader.KEY_CONTEXT);
            object.setPropertyValue(this._objFieldName, (Object)new AgencyAndId(ctx.getDefaultAgencyId(), id));
        }
    }

    private static class RequiredPathFieldMappingImpl
    extends AbstractAgencyFieldMappingImpl {
        private String[] _agencyIdPathProperties;

        public RequiredPathFieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, String path) {
            super(entityType, csvFieldName, objFieldName, true);
            this._agencyIdPathProperties = path.split("\\.");
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            String id = (String)csvValues.get(this._csvFieldName);
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new MissingRequiredFieldException(this._entityType, this._csvFieldName);
            }
            object.setPropertyValue(this._objFieldName, (Object)new AgencyAndId(this.resolveAgencyId(object), id));
        }

        private String resolveAgencyId(BeanWrapper object) {
            for (String property : this._agencyIdPathProperties) {
                Object value = object.getPropertyValue(property);
                object = BeanWrapperFactory.wrap((Object)value);
            }
            return object.getWrappedInstance(Object.class).toString();
        }
    }

    private static class OptionalPathFieldMappingImpl
    extends AbstractAgencyFieldMappingImpl {
        private String[] _agencyIdPathProperties;

        public OptionalPathFieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, String path) {
            super(entityType, csvFieldName, objFieldName, false);
            this._agencyIdPathProperties = path.split("\\.");
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            String id = (String)csvValues.get(this._csvFieldName);
            if (StringUtils.isBlank((CharSequence)id)) {
                return;
            }
            object.setPropertyValue(this._objFieldName, (Object)new AgencyAndId(this.resolveAgencyId(object), id));
        }

        private String resolveAgencyId(BeanWrapper object) {
            for (String property : this._agencyIdPathProperties) {
                Object value = object.getPropertyValue(property);
                object = BeanWrapperFactory.wrap((Object)value);
            }
            return object.getWrappedInstance(Object.class).toString();
        }
    }

    private static abstract class AbstractAgencyFieldMappingImpl
    extends AbstractFieldMapping {
        public AbstractAgencyFieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, boolean required) {
            super(entityType, csvFieldName, objFieldName, required);
        }

        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            if (this.isMissingAndOptional(object)) {
                return;
            }
            AgencyAndId id = (AgencyAndId)object.getPropertyValue(this._objFieldName);
            csvValues.put(this._csvFieldName, id.getId());
        }
    }
}

