/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model;

import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.ShapePointProxy;
import org.onebusaway.gtfs.serialization.mappings.InternAgencyIdFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.LatLonFieldMappingFactory;

@CsvFields(filename="shapes.txt", required=false)
public final class ShapePoint
extends IdentityBean<Integer>
implements Comparable<ShapePoint> {
    private static final long serialVersionUID = 1L;
    public static final double MISSING_VALUE = -999.0;
    @CsvField(ignore=true)
    private int id;
    @CsvField(mapping=InternAgencyIdFieldMappingFactory.class)
    private AgencyAndId shapeId;
    @CsvField(name="shape_pt_sequence")
    private int sequence;
    @CsvField(name="shape_pt_lat", mapping=LatLonFieldMappingFactory.class)
    private double lat;
    @CsvField(name="shape_pt_lon", mapping=LatLonFieldMappingFactory.class)
    private double lon;
    @CsvField(optional=true, name="shape_dist_traveled")
    private double distTraveled = -999.0;
    @CsvField(ignore=true)
    private transient ShapePointProxy proxy;

    public ShapePoint() {
    }

    public ShapePoint(ShapePoint shapePoint) {
        this.id = shapePoint.id;
        this.shapeId = shapePoint.shapeId;
        this.sequence = shapePoint.sequence;
        this.distTraveled = shapePoint.distTraveled;
        this.lat = shapePoint.lat;
        this.lon = shapePoint.lon;
    }

    @Override
    public Integer getId() {
        if (this.proxy != null) {
            return this.proxy.getId();
        }
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        if (this.proxy != null) {
            this.proxy.setId(id);
            return;
        }
        this.id = id;
    }

    public AgencyAndId getShapeId() {
        if (this.proxy != null) {
            return this.proxy.getShapeId();
        }
        return this.shapeId;
    }

    public void setShapeId(AgencyAndId shapeId) {
        if (this.proxy != null) {
            this.proxy.setShapeId(shapeId);
            return;
        }
        this.shapeId = shapeId;
    }

    public int getSequence() {
        if (this.proxy != null) {
            return this.proxy.getSequence();
        }
        return this.sequence;
    }

    public void setSequence(int sequence) {
        if (this.proxy != null) {
            this.proxy.setSequence(sequence);
            return;
        }
        this.sequence = sequence;
    }

    public boolean isDistTraveledSet() {
        if (this.proxy != null) {
            return this.proxy.isDistTraveledSet();
        }
        return this.distTraveled != -999.0;
    }

    public double getDistTraveled() {
        if (this.proxy != null) {
            return this.proxy.getDistTraveled();
        }
        return this.distTraveled;
    }

    public void setDistTraveled(double distTraveled) {
        if (this.proxy != null) {
            this.proxy.setDistTraveled(distTraveled);
            return;
        }
        this.distTraveled = distTraveled;
    }

    public void clearDistTraveled() {
        if (this.proxy != null) {
            this.proxy.clearDistTraveled();
            return;
        }
        this.distTraveled = -999.0;
    }

    public double getLat() {
        if (this.proxy != null) {
            return this.proxy.getLat();
        }
        return this.lat;
    }

    public void setLat(double lat) {
        if (this.proxy != null) {
            this.proxy.setLat(lat);
            return;
        }
        this.lat = lat;
    }

    public double getLon() {
        if (this.proxy != null) {
            return this.proxy.getLon();
        }
        return this.lon;
    }

    public void setLon(double lon) {
        if (this.proxy != null) {
            this.proxy.setLon(lon);
            return;
        }
        this.lon = lon;
    }

    public void setProxy(ShapePointProxy proxy) {
        this.proxy = proxy;
    }

    public ShapePointProxy getProxy() {
        return this.proxy;
    }

    public String toString() {
        return "<ShapePoint " + String.valueOf(this.getShapeId()) + " #" + this.getSequence() + " (" + this.getLat() + "," + this.getLon() + ")>";
    }

    @Override
    public int compareTo(ShapePoint o) {
        return this.getSequence() - o.getSequence();
    }
}

