/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model;

import org.jspecify.annotations.Nullable;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.serialization.mappings.DefaultAgencyIdFieldMappingFactory;

@CsvFields(filename="fare_transfer_rules.txt", required=false)
public final class FareTransferRule
extends IdentityBean<String> {
    private static final int MISSING_VALUE = -999;
    @CsvField(name="from_leg_group_id", optional=true, mapping=DefaultAgencyIdFieldMappingFactory.class)
    private AgencyAndId fromLegGroupId;
    @CsvField(name="to_leg_group_id", optional=true, mapping=DefaultAgencyIdFieldMappingFactory.class)
    private AgencyAndId toLegGroupId;
    @CsvField(name="transfer_count", optional=true)
    private int transferCount = -999;
    @CsvField(name="duration_limit", optional=true)
    private int durationLimit = -999;
    @CsvField(name="duration_limit_type", optional=true)
    private int durationLimitType = -999;
    @CsvField(name="fare_transfer_type", optional=true)
    private int fareTransferType = -999;
    @CsvField(name="fare_product_id", optional=true, mapping=DefaultAgencyIdFieldMappingFactory.class)
    private AgencyAndId fareProductId;

    public @Nullable AgencyAndId getFromLegGroupId() {
        return this.fromLegGroupId;
    }

    public void setFromLegGroupId(AgencyAndId fromLegGroupId) {
        this.fromLegGroupId = fromLegGroupId;
    }

    public @Nullable AgencyAndId getToLegGroupId() {
        return this.toLegGroupId;
    }

    public void setToLegGroupId(AgencyAndId toLegGroupId) {
        this.toLegGroupId = toLegGroupId;
    }

    public int getTransferCount() {
        return this.transferCount;
    }

    public void setTransferCount(int transferCount) {
        this.transferCount = transferCount;
    }

    public int getDurationLimit() {
        return this.durationLimit;
    }

    public void setDurationLimit(int durationLimit) {
        this.durationLimit = durationLimit;
    }

    public int getDurationLimitType() {
        return this.durationLimitType;
    }

    public void setDurationLimitType(int durationLimitType) {
        this.durationLimitType = durationLimitType;
    }

    public int getFareTransferType() {
        return this.fareTransferType;
    }

    public void setFareTransferType(int fareTransferType) {
        this.fareTransferType = fareTransferType;
    }

    public @Nullable AgencyAndId getFareProductId() {
        return this.fareProductId;
    }

    public void setFareProductId(AgencyAndId fareProductId) {
        this.fareProductId = fareProductId;
    }

    @Override
    public String getId() {
        return "%s_%s_%s_%s_%s".formatted(this.fromLegGroupId, this.toLegGroupId, this.fareProductId, this.transferCount, this.durationLimit);
    }

    @Override
    public void setId(String id) {
    }

    public boolean isTransferCountSet() {
        return this.transferCount != -999;
    }

    public boolean isDurationLimitSet() {
        return this.durationLimit != -999;
    }

    public boolean isDurationLimitTypeSet() {
        return this.durationLimitType != -999;
    }

    public boolean isFareTransferTypeSet() {
        return this.fareTransferType != -999;
    }
}

