/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.stream.Collectors;

public class ZipHandler {
    public static final String ZIP_SCHEME = "jar:file:";
    private File zipFile;

    public ZipHandler(File zipFile) {
        this.zipFile = zipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readTextFromFile(String fileInZip) throws IOException {
        final StringBuffer content = new StringBuffer();
        try (FileSystem zipFileSystem = null;){
            URI uri = URI.create(ZIP_SCHEME + this.zipFile.getAbsolutePath());
            zipFileSystem = FileSystems.newFileSystem(uri, new HashMap());
            Path root = zipFileSystem.getPath(fileInZip, new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    content.append(Files.lines(file).collect(Collectors.joining(System.lineSeparator())));
                    return FileVisitResult.TERMINATE;
                }
            });
            String string = content.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTextToFile(String fileInZip, String content) throws IOException {
        try (FileSystem zipFileSystem = null;){
            URI uri = URI.create(ZIP_SCHEME + this.zipFile.toURI().getPath());
            zipFileSystem = FileSystems.newFileSystem(uri, new HashMap());
            Path newZipEntry = zipFileSystem.getPath(fileInZip, new String[0]);
            BufferedWriter writer = Files.newBufferedWriter(newZipEntry, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
            writer.write(content);
            ((Writer)writer).close();
        }
    }
}

