/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileSupport {
    private final List<File> toDelete = new ArrayList<File>();

    public void markForDeletion(File file) {
        this.toDelete.add(file);
    }

    public void cleanup() {
        for (File file : this.toDelete) {
            this.deleteFileRecursively(file);
        }
        this.toDelete.clear();
    }

    public void deleteFileRecursively(File file) {
        File[] files;
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                this.deleteFileRecursively(child);
            }
        }
        file.delete();
    }
}

