/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.List;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTripHeadsignByDestinationStrategy
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(UpdateTripHeadsignByDestinationStrategy.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        int update = 0;
        int fallback = 0;
        for (Trip trip : dao.getAllTrips()) {
            String tripHeadSign;
            List stopTimes = dao.getStopTimesForTrip(trip);
            if (stopTimes == null || stopTimes.size() <= 0 || (tripHeadSign = ((StopTime)stopTimes.get(stopTimes.size() - 1)).getStop().getName()) == null) continue;
            trip.setTripHeadsign(tripHeadSign);
            ++update;
        }
        this._log.info("trip headsign update:{} fallback: {}", (Object)update, (Object)fallback);
    }
}

