/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruncateNewCalendarStatements
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(TruncateNewCalendarStatements.class);
    @CsvField(optional=true)
    private int calendarField = 2;
    @CsvField(optional=true)
    private int calendarAmount = 1;

    public void setCalendarField(int calendarField) {
        this.calendarField = calendarField;
    }

    public void setCalendarAmount(int calendarAmount) {
        this.calendarAmount = calendarAmount;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext transformContext, GtfsMutableRelationalDao gtfsMutableRelationalDao) {
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        Calendar c = Calendar.getInstance();
        c.add(this.calendarField, this.calendarAmount);
        Date oneMonthFromNow = c.getTime();
        HashSet<ServiceCalendar> serviceCalendarsToRemove = new HashSet<ServiceCalendar>();
        for (ServiceCalendar calendar : gtfsMutableRelationalDao.getAllCalendars()) {
            if (!calendar.getStartDate().getAsDate().after(oneMonthFromNow)) continue;
            serviceCalendarsToRemove.add(calendar);
        }
        for (ServiceCalendar serviceCalendar : serviceCalendarsToRemove) {
            removeEntityLibrary.removeCalendar(gtfsMutableRelationalDao, serviceCalendar.getServiceId());
        }
        HashSet<ServiceCalendarDate> serviceCalendarDatesToRemove = new HashSet<ServiceCalendarDate>();
        for (ServiceCalendarDate calendarDate : gtfsMutableRelationalDao.getAllCalendarDates()) {
            if (!calendarDate.getDate().getAsDate().after(oneMonthFromNow)) continue;
            serviceCalendarDatesToRemove.add(calendarDate);
        }
        for (ServiceCalendarDate serviceCalendarDate : serviceCalendarDatesToRemove) {
            removeEntityLibrary.removeServiceCalendarDate(gtfsMutableRelationalDao, serviceCalendarDate);
        }
    }
}

