/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.File;
import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.InputLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyRouteIds
implements GtfsTransformStrategy {
    private static final int ROUTE_ID = 0;
    private static final int ROUTE_NAME = 1;
    private static Logger _log = LoggerFactory.getLogger(VerifyRouteIds.class);

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        String agency = ((Trip)dao.getAllTrips().iterator().next()).getId().getAgencyId();
        File routesFile = new File((String)context.getParameter("verifyRoutesFile"));
        if (!routesFile.exists()) {
            throw new IllegalStateException("verifyRouteIds Routes file does not exist: " + routesFile.getName());
        }
        List<String> routeLines = new InputLibrary().readList((String)context.getParameter("verifyRoutesFile"));
        _log.info("Length of route file: {}", (Object)routeLines.size());
        for (String routeInfo : routeLines) {
            String[] routeArray = routeInfo.split(",");
            if (routeArray == null) {
                _log.info("routeArray is null");
                continue;
            }
            if (routeArray.length < 2) {
                _log.info("routeArray.length: {} {}", (Object)routeArray.length, (Object)routeInfo);
                continue;
            }
            String routeId = routeArray[0];
            String routeName = routeArray[1];
            Route route = dao.getRouteForId(new AgencyAndId(agency, routeId));
            if (route != null) {
                if (route.getLongName().contains(routeName)) continue;
                _log.error("NJT MNR West of Hudson Route Id->Route name error. CSV routeId: {} routeName: {} GTFS Route id: {}, longName {}", new Object[]{routeId, routeName, route.getId().getId(), route.getLongName()});
                throw new IllegalStateException("NJT MNR West of Hudson Route Id->Route name error. Route id is for unexpected route name");
            }
            _log.error("NJT MNR West of Hudson Route Id->Route name error. Route id is not present in GTFS. Expected CSV routeId: {} routeName: {}", (Object)routeId, (Object)routeName);
            throw new IllegalStateException("NJT MNR West of Hudson Route Id->Route name error. Route is null");
        }
    }
}

