/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.ArrayList;
import java.util.HashMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTripIdById
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(UpdateTripIdById.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        HashMap<String, Trip> tripsUpdated = new HashMap<String, Trip>();
        ArrayList<Trip> tripsToRemove = new ArrayList<Trip>();
        this._log.info("Total dao {}", (Object)dao.getAllTrips().size());
        this._log.info("Stop times: {}", (Object)dao.getAllStopTimes().size());
        for (Trip trip : dao.getAllTrips()) {
            if (trip.getMtaTripId() == null) continue;
            if (tripsUpdated.containsKey(trip.getMtaTripId())) {
                tripsToRemove.add(trip);
                for (StopTime stopTime : dao.getStopTimesForTrip(trip)) {
                    stopTime.setTrip((Trip)tripsUpdated.get(trip.getMtaTripId()));
                }
                continue;
            }
            tripsUpdated.put(trip.getMtaTripId(), trip);
            trip.setId(new AgencyAndId(trip.getId().getAgencyId(), trip.getMtaTripId()));
        }
        for (Trip tripToRemove : tripsToRemove) {
            dao.removeEntity((IdentityBean)tripToRemove);
        }
        this._log.info("Total dao {}", (Object)dao.getAllTrips().size());
        this._log.info("Stop times: {}", (Object)dao.getAllStopTimes().size());
    }
}

