/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.collections.ServiceIdKey;
import org.onebusaway.gtfs_transformer.services.EntityTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class ServiceIdTransformStrategyImpl
implements EntityTransformStrategy {
    private final String _oldServiceId;
    private String _newServiceId;

    public ServiceIdTransformStrategyImpl(String oldServiceId, String newServiceId) {
        this._oldServiceId = oldServiceId;
        this._newServiceId = newServiceId;
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao, Object entity) {
        AgencyAndId oldServiceId = context.resolveId(ServiceIdKey.class, this._oldServiceId);
        AgencyAndId newServiceId = context.resolveId(ServiceIdKey.class, this._newServiceId);
        ServiceCalendar calendar = dao.getCalendarForServiceId(oldServiceId);
        if (calendar != null) {
            calendar.setServiceId(newServiceId);
        }
        for (ServiceCalendarDate calendarDate : dao.getCalendarDatesForServiceId(oldServiceId)) {
            calendarDate.setServiceId(newServiceId);
        }
        for (Trip trip : dao.getTripsForServiceId(oldServiceId)) {
            trip.setServiceId(newServiceId);
        }
    }
}

