/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;

public class TransformLibrary {
    public void removeEntity(GtfsMutableRelationalDao dao, Object obj) {
        if (obj instanceof Agency) {
            Agency agency = (Agency)obj;
            this.removeAgency(dao, agency);
        } else if (obj instanceof Route) {
            Route route = (Route)obj;
            this.removeRoute(dao, route);
        } else if (obj instanceof Stop) {
            Stop stop = (Stop)obj;
            this.removeStop(dao, stop);
        } else if (obj instanceof Trip) {
            Trip trip = (Trip)obj;
            this.removeTrip(dao, trip);
        } else if (obj instanceof StopTime) {
            StopTime time = (StopTime)obj;
            this.removeStopTime(dao, time);
        }
    }

    private void removeAgency(GtfsMutableRelationalDao dao, Agency agency) {
        for (Route route : dao.getRoutesForAgency(agency)) {
            this.removeRoute(dao, route);
        }
        dao.removeEntity((IdentityBean)agency);
    }

    private void removeRoute(GtfsMutableRelationalDao dao, Route route) {
        for (Trip trip : dao.getTripsForRoute(route)) {
            this.removeTrip(dao, trip);
        }
        dao.removeEntity((IdentityBean)route);
    }

    private void removeTrip(GtfsMutableRelationalDao dao, Trip trip) {
        for (StopTime stopTime : dao.getStopTimesForTrip(trip)) {
            this.removeStopTime(dao, stopTime);
        }
        for (Frequency frequency : dao.getFrequenciesForTrip(trip)) {
            this.removeFrequency(dao, frequency);
        }
        dao.removeEntity((IdentityBean)trip);
    }

    private void removeFrequency(GtfsMutableRelationalDao dao, Frequency frequency) {
        dao.removeEntity((IdentityBean)frequency);
    }

    private void removeStop(GtfsMutableRelationalDao dao, Stop stop) {
        for (StopTime stopTime : dao.getStopTimesForStop(stop)) {
            this.removeStopTime(dao, stopTime);
        }
        dao.removeEntity((IdentityBean)stop);
    }

    private void removeStopTime(GtfsMutableRelationalDao dao, StopTime stopTime) {
        dao.removeEntity((IdentityBean)stopTime);
    }
}

