/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeStopIdsFromReferenceStrategy
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(MergeStopIdsFromReferenceStrategy.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        List<String> ignoreMatches = this.readList((String)context.getParameter("ignoreStops"));
        int matched = 0;
        int unmatched = 0;
        HashMap<String, Stop> referenceStopNamesToStops = new HashMap<String, Stop>();
        for (Stop stop : reference.getAllStops()) {
            referenceStopNamesToStops.put(stop.getName(), stop);
        }
        for (Stop stop : dao.getAllStops()) {
            Stop referenceStop = (Stop)referenceStopNamesToStops.get(stop.getName());
            if (referenceStop == null && stop.getName().contains("-")) {
                referenceStop = (Stop)referenceStopNamesToStops.get(this.swap(stop.getName()));
            }
            if (referenceStop == null && stop.getName().contains("Park")) {
                referenceStop = (Stop)referenceStopNamesToStops.get(stop.getName().replaceAll("Park", "Pk"));
            }
            if (referenceStop == null && stop.getName().contains("-")) {
                referenceStop = (Stop)referenceStopNamesToStops.get(this.swap(stop.getName().replaceAll("Park", "Pk")));
            }
            if (referenceStop == null && stop.getName().contains("Pk")) {
                referenceStop = (Stop)referenceStopNamesToStops.get(stop.getName().replaceAll("Pk", "Park"));
            }
            if (referenceStop == null && stop.getName().contains("-")) {
                referenceStop = (Stop)referenceStopNamesToStops.get(this.swap(stop.getName().replaceAll("Pk", "Park")));
            }
            if (referenceStop != null) {
                stop.setId(referenceStop.getId());
                ++matched;
                continue;
            }
            ++unmatched;
            if (ignoreMatches.contains(stop.getName())) continue;
            this._log.error("unmatched stop |{}|", (Object)stop.getName());
        }
        this._log.info("Stops replaced with {} matched and {} remaining", (Object)matched, (Object)unmatched);
    }

    private String swap(String s) {
        String swap = s.replaceAll("(.*)-(.*)", "$2 - $1").replaceAll("^[ ]", "").replaceAll("[ ]$", "");
        this._log.trace("Swapped |{}| to |{}|", (Object)s, (Object)swap);
        return swap;
    }

    private List<String> readList(String fileName) {
        ArrayList<String> list = new ArrayList<String>();
        if (fileName == null || fileName.length() == 0) {
            return list;
        }
        BufferedReader reader = null;
        int count = 0;
        try {
            reader = new BufferedReader(new FileReader(fileName));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String s = this.sanitize(line);
                if (s == null) continue;
                list.add(s);
                ++count;
            }
        }
        catch (FileNotFoundException e) {
            this._log.error("failed to load stop ignore file={}", (Object)fileName, (Object)e);
            return list;
        }
        catch (IOException ioe) {
            this._log.error("error reading stop ignore file={}", (Object)fileName, (Object)ioe);
        }
        this._log.info("Successfully read {} entries from {}", (Object)count, (Object)fileName);
        return list;
    }

    private String sanitize(String s) {
        if (s == null) {
            return s;
        }
        s = s.trim();
        s = s.replaceAll("^\"", "").replaceAll("\"$", "");
        return s;
    }
}

